%--------------------------------------------------------------------------
% File     : CAT009=DomXYDomY-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Category Theory
% Problem  : If xy is defined, then domain(xy) = domain(y)
% Version  : [Mitchell, 1967] axioms.
% English  : 

% Refs     : Mitchell B. (1967), Theory of categories, (Pure and Applied 
%            Mathematics, Volume 17), Academic Press.
% Source   : [ANL]
% Names    : p9.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   33 (   0 non-Horn)(   9 unit)
%            Number of literals          :   79 (  22 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :    5 (   2 constant)
%            Number of variables         :   88 (   5 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Mitchell's axioms for category theory 
include('Axioms/CAT001-0.ax').
include('Axioms/CAT001-0.eq').
%--------------------------------------------------------------------------
input_clause(ba_defined,hypothesis,
    [++defined(b,a)]).

input_clause(prove_domain_of_ba_equals_domain_of_a,theorem,
    [--equal(domain(compose(b,a)),domain(a))]).
%--------------------------------------------------------------------------
