%--------------------------------------------------------------------------
% File     : CAT008=DomXCodY-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Category Theory
% Problem  : If xy is defined then domain(x) = codomain(y)
% Version  : [Mitchell, 1967] axioms.
% English  : 

% Refs     : Mitchell B. (1967), Theory of categories, (Pure and Applied 
%            Mathematics, Volume 17), Academic Press.
%          : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : C8 [McCharen, et al., 1976]
%          : p8.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   33 (   0 non-Horn)(   9 unit)
%            Number of literals          :   79 (  22 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :    5 (   2 constant)
%            Number of variables         :   88 (   5 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Mitchell's axioms for category theory 
include('Axioms/CAT001-0.ax').
include('Axioms/CAT001-0.eq').
%--------------------------------------------------------------------------
input_clause(ab_defined,hypothesis,
    [++defined(a,b)]).

input_clause(prove_domain_of_a_equals_codomain_of_b,theorem,
    [--equal(domain(a),codomain(b))]).
%--------------------------------------------------------------------------
