%--------------------------------------------------------------------------
% File     : CAT007=DomEqCod-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Category Theory
% Problem  : If domain(x) = codomain(y) then xy is defined
% Version  : [Scott, 1979] axioms : Reduced > Complete.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Scott D. (1979), Identity & Existence in Intuitionist Logic, 
%            In Fournam M.P. (Ed), Durham Proceedings Applications 
%            of Sheaves, (Lecture Notes in Mathematics Volume 753), 
%            660-696.
% Source   : [ANL]
% Names    : C7 [McCharen, et al., 1976]
%          : p7.ver3.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   12 (   2 non-Horn)(   5 unit)
%            Number of literals          :   23 (  15 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    6 (   2 constant)
%            Number of variables         :   15 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : In Scott's axiom system, this is an axiom; but 
%            it is dependant, vis. proof included.
%          : Axioms simplified by Art Quaife.
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
%----Supply the axioms upon which it is dependant.

%----Category theory axioms 
input_clause(domain_has_elements,axiom,
    [--there_exists(domain(X)),
     ++there_exists(X)]).

input_clause(domain_codomain_composition2,axiom,
    [--there_exists(domain(X)),
     --equal(domain(X),codomain(Y)),
     ++there_exists(compose(X,Y))]).

%----Axiom of indiscernibles 
input_clause(indiscernibles1,axiom,
    [++there_exists(f1(X,Y)),
     ++equal(X,Y)]).

input_clause(indiscernibles2,axiom,
    [++equal(X,f1(X,Y)),
     ++equal(Y,f1(X,Y)),
     ++equal(X,Y)]).

input_clause(indiscernibles3,axiom,
    [--equal(X,f1(X,Y)),
     --equal(Y,f1(X,Y)),
     ++equal(X,Y)]).

input_clause(domain_of_c2_exists,hypothesis,
    [++there_exists(domain(c2))]).

input_clause(domain_of_c1_exists,hypothesis,
    [++there_exists(domain(c1))]).

input_clause(domain_of_c2_equals_codomain_of_c1,hypothesis,
    [++equal(domain(c2),codomain(c1))]).

input_clause(prove_c1_c2_is_defined,theorem,
    [--there_exists(compose(c2,c1))]).
%--------------------------------------------------------------------------
