%--------------------------------------------------------------------------
% File     : CAT006=CodUnqLId-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Category Theory
% Problem  : Codomain is the unique left identity
% Version  : [Scott, 1979] axioms : Reduced > Complete.
% English  : codomain(x) is the unique identity j such that jx is defined.

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Scott D. (1979), Identity & Existence in Intuitionist Logic, 
%            In Fournam M.P. (Ed), Durham Proceedings Applications 
%            of Sheaves, (Lecture Notes in Mathematics Volume 753), 
%            660-696.
% Source   : [ANL]
% Names    : C6 [McCharen, et al., 1976]
%          : p6.ver3.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   33 (   2 non-Horn)(   6 unit)
%            Number of literals          :   70 (  39 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    6 (   2 constant)
%            Number of variables         :   63 (   4 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    3

% Comments : Axioms simplified by Art Quaife.
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Scott's axioms for category theory 
include('Axioms/CAT003-0.ax').
include('Axioms/CAT003-0.eq').
%--------------------------------------------------------------------------
%----Denial of theorem: d is an identity which is not cod(a), 
input_clause(da_exists,hypothesis,
    [++there_exists(compose(d,a))]).

input_clause(xd_equals_x,hypothesis,
    [--there_exists(compose(X,d)),
     ++equal(compose(X,d),X)]).

input_clause(dx_equals_x,hypothesis,
    [--there_exists(compose(d,X)),
     ++equal(compose(d,X),X)]).

input_clause(prove_codomain_of_a_is_d,theorem,
    [--equal(codomain(a),d)]).
%--------------------------------------------------------------------------
