%--------------------------------------------------------------------------
% File     : CAT006=CodUnqLId-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Category Theory
% Problem  : Codomain is the unique left identity
% Version  : [Mitchell, 1967] axioms.
% English  : codomain(x) is the unique identity j such that jx is defined.

% Refs     : Mitchell B. (1967), Theory of categories, (Pure and Applied 
%            Mathematics, Volume 17), Academic Press.
%          : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : C6 [McCharen, et al., 1976]
%          : p6.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   34 (   0 non-Horn)(  10 unit)
%            Number of literals          :   80 (  22 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :    5 (   2 constant)
%            Number of variables         :   88 (   5 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Mitchell's axioms for category theory 
include('Axioms/CAT001-0.ax').
include('Axioms/CAT001-0.eq').
%--------------------------------------------------------------------------
input_clause(ha_defined,hypothesis,
    [++defined(h,a)]).

input_clause(h_is_the_identity_map,hypothesis,
    [++identity_map(h)]).

input_clause(prove_codomain_of_a_is_h,theorem,
    [--equal(codomain(a),h)]).
%--------------------------------------------------------------------------
