%--------------------------------------------------------------------------
% File     : CAT005=DomUnqRId-4 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Category Theory
% Problem  : Domain is the unique right identity
% Version  : [Scott, 1979] axioms : Reduced > Complete.
% English  : domain(x) is the unique identity i such that xi is defined.

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Scott D. (1979), Identity & Existence in Intuitionist Logic, 
%            In Fournam M.P. (Ed), Durham Proceedings Applications 
%            of Sheaves, (Lecture Notes in Mathematics Volume 753), 
%            660-696.
% Source   : [ANL]
% Names    : C5 [McCharen, et al., 1976]

% Status   : 
% Syntax   : Number of clauses           :   25 (   0 non-Horn)(   6 unit)
%            Number of literals          :   50 (  27 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    5 (   2 constant)
%            Number of variables         :   45 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : The dependent axioms have been removed.
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Scott's axioms for category theory 
include('Axioms/CAT004-0.ax').
include('Axioms/CAT004-0.eq').
%--------------------------------------------------------------------------
%----Denial of the theorem:  d is an identity not equal to dom(a), 
input_clause(ad_exists,hypothesis,
    [++there_exists(compose(a,d))]).

input_clause(xd_equals_x,hypothesis,
    [--there_exists(compose(X,d)),
     ++equal(compose(X,d),X)]).

input_clause(dy_equals_y,hypothesis,
    [--there_exists(compose(d,Y)),
     ++equal(compose(d,Y),Y)]).

input_clause(prove_domain_of_a_is_d,theorem,
    [--equal(domain(a),d)]).
%--------------------------------------------------------------------------
