%--------------------------------------------------------------------------
% File     : CAT005=DomUnqRId-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Category Theory
% Problem  : Domain is the unique right identity
% Version  : [Mitchell, 1967] axioms.
% English  : domain(x) is the unique identity i such that xi is defined.

% Refs     : Mitchell B. (1967), Theory of categories, (Pure and Applied 
%            Mathematics, Volume 17), Academic Press.
%          : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : C5 [McCharen, et al., 1976]
%          : p5.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   34 (   0 non-Horn)(  10 unit)
%            Number of literals          :   80 (  22 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :    5 (   2 constant)
%            Number of variables         :   88 (   5 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Mitchell's axioms for category theory 
include('Axioms/CAT001-0.ax').
include('Axioms/CAT001-0.eq').
%--------------------------------------------------------------------------
input_clause(ad_defined,hypothesis,
    [++defined(a,d)]).

input_clause(d_is_identity_map,hypothesis,
    [++identity_map(d)]).

input_clause(prove_domain_of_a_is_d,theorem,
    [--equal(domain(a),d)]).
%--------------------------------------------------------------------------
