%--------------------------------------------------------------------------
% File     : CAT004=Epim2-4 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Category Theory
% Problem  : X and Y epimorphisms, XY well-defined => XY epimorphism
% Version  : [Scott, 1979] axioms : Reduced > Complete.
% English  : If x and y are epimorphisms and xy is well-defined, then 
%            xy is an epimorphism.

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Scott D. (1979), Identity & Existence in Intuitionist Logic, 
%            In Fournam M.P. (Ed), Durham Proceedings Applications 
%            of Sheaves, (Lecture Notes in Mathematics Volume 753), 
%            660-696.
% Source   : [ANL]
% Names    : C4 [McCharen, et al., 1976]

% Status   : 
% Syntax   : Number of clauses           :   27 (   0 non-Horn)(   8 unit)
%            Number of literals          :   54 (  32 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    7 (   4 constant)
%            Number of variables         :   49 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : The dependent axioms have been removed.
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Scott's axioms for category theory 
include('Axioms/CAT004-0.ax').
include('Axioms/CAT004-0.eq').
%--------------------------------------------------------------------------
input_clause(assume_ab_exists,hypothesis,
    [++there_exists(compose(a,b))]).

input_clause(cancellation_for_product1,hypothesis,
    [--equal(compose(X,a),Y),
     --equal(compose(Z,a),Y),
     ++equal(X,Z)]).

input_clause(cancellation_for_product2,hypothesis,
    [--equal(compose(X,b),Y),
     --equal(compose(Z,b),Y),
     ++equal(X,Z)]).

input_clause(assume_h_exists,hypothesis,
    [++there_exists(h)]).

input_clause(h_ab_equals_g_ab,hypothesis,
    [++equal(compose(h,compose(a,b)),compose(g,compose(a,b)))]).

input_clause(prove_h_equals_g,theorem,
    [--equal(h,g)]).
%--------------------------------------------------------------------------
