%--------------------------------------------------------------------------
% File     : CAT004=Epim2-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Category Theory
% Problem  : X and Y epimorphisms, XY well-defined => XY epimorphism
% Version  : [Quaife, 1989] (equality) axioms.
% English  : If x and y are epimorphisms and xy is well-defined, then 
%            xy is an epimorphism.

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Quaife A. (1989), Email to Larry Wos 05/02/89.
% Source   : [ANL]
% Names    : C4 [McCharen, et al., 1976]
%          : p4.ver2.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   21 (   0 non-Horn)(  10 unit)
%            Number of literals          :   40 (  40 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    7 (   4 constant)
%            Number of variables         :   33 (   0 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Quaife's axioms for category theory 
include('Axioms/CAT002-0.ax').
%--------------------------------------------------------------------------
input_clause(epimorphism1,hypothesis,
    [--equal(codomain(a),domain(X)),
     --equal(compose(a,X),Y),
     --equal(codomain(a),domain(Z)),
     --equal(compose(a,Z),Y),
     ++equal(X,Z)]).

input_clause(epimorphism2,hypothesis,
    [--equal(codomain(b),domain(X)),
     --equal(compose(b,X),Y),
     --equal(codomain(b),domain(Z)),
     --equal(compose(b,Z),Y),
     ++equal(X,Z)]).

input_clause(codomain_of_a_equals_domain_of_b,hypothesis,
    [++equal(codomain(a),domain(b))]).

input_clause(codomain_of_ab_equals_domain_of_h,hypothesis,
    [++equal(codomain(compose(a,b)),domain(h))]).

input_clause(codomain_of_ab_equals_domain_of_g,hypothesis,
    [++equal(codomain(compose(a,b)),domain(g))]).

input_clause(ab_h_equals_ab_g,hypothesis,
    [++equal(compose(compose(a,b),h),compose(compose(a,b),g))]).

input_clause(prove_h_equals_g,theorem,
    [--equal(h,g)]).
%--------------------------------------------------------------------------
