%--------------------------------------------------------------------------
% File     : CAT004=Epim2-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Category Theory
% Problem  : X and Y epimorphisms, XY well-defined => XY epimorphism
% Version  : [Mitchell, 1967] axioms.
% English  : If x and y are epimorphisms and xy is well-defined, then 
%            xy is an epimorphism.

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : C4 [McCharen, et al., 1976]
%          : p4.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   37 (   0 non-Horn)(  11 unit)
%            Number of literals          :   87 (  24 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :    9 (   6 constant)
%            Number of variables         :   94 (   5 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Mitchell's axioms for category theory 
include('Axioms/CAT001-0.ax').
include('Axioms/CAT001-0.eq').
%--------------------------------------------------------------------------
input_clause(cancellation_for_product1,hypothesis,
    [--product(X,a,W),
     --product(Y,a,W),
     ++equal(X,Y)]).

input_clause(cancellation_for_product2,hypothesis,
    [--product(X,b,W),
     --product(Y,b,W),
     ++equal(X,Y)]).

input_clause(ab_equals_c,hypothesis,
    [++product(a,b,c)]).

input_clause(hc_equals_d,hypothesis,
    [++product(h,c,d)]).

input_clause(gc_equals_d,hypothesis,
    [++product(g,c,d)]).

input_clause(prove_h_equals_g,theorem,
    [--equal(h,g)]).
%--------------------------------------------------------------------------
