%--------------------------------------------------------------------------
% File     : CAT003=Epim1-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Category Theory
% Problem  : XY epimorphism => X epimorphism
% Version  : [Scott, 1979] axioms : Reduced > Complete.
% English  : If xy is an epimorphism, then x is an epimorphism.

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Scott D. (1979), Identity & Existence in Intuitionist Logic, 
%            In Fournam M.P. (Ed), Durham Proceedings Applications 
%            of Sheaves, (Lecture Notes in Mathematics Volume 753), 
%            660-696.
% Source   : [ANL]
% Names    : C3 [McCharen, et al., 1976]
%          : p3.ver3.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   34 (   2 non-Horn)(   8 unit)
%            Number of literals          :   71 (  41 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    8 (   4 constant)
%            Number of variables         :   64 (   4 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    3

% Comments : Axioms simplified by Art Quaife.
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Scott's axioms for category theory 
include('Axioms/CAT003-0.ax').
include('Axioms/CAT003-0.eq').
%--------------------------------------------------------------------------
input_clause(assume_ab_exists,hypothesis,
    [++there_exists(compose(a,b))]).

input_clause(epimorphism,hypothesis,
    [--equal(compose(X,compose(a,b)),Y),
     --equal(compose(Z,compose(a,b)),Y),
     ++equal(X,Z)]).

input_clause(assume_h_exists,hypothesis,
    [++there_exists(h)]).

input_clause(ha_equals_ga,hypothesis,
    [++equal(compose(h,a),compose(g,a))]).

input_clause(prove_g_equals_h,theorem,
    [--equal(g,h)]).
%--------------------------------------------------------------------------
