%--------------------------------------------------------------------------
% File     : CAT003=Epim1-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Category Theory
% Problem  : XY epimorphism => X epimorphism
% Version  : [Quaife, 1989] (equality) axioms.
% English  : If xy is an epimorphism, then x is an epimorphism.

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Quaife A. (1989), Email to Larry Wos 05/02/89.
% Source   : [ANL]
% Names    : C3 [McCharen, et al., 1976]
%          : p3.ver2.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   20 (   0 non-Horn)(  10 unit)
%            Number of literals          :   35 (  35 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    7 (   4 constant)
%            Number of variables         :   30 (   0 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Quaife's axioms for category theory 
include('Axioms/CAT002-0.ax').
%--------------------------------------------------------------------------
input_clause(endomorphism,hypothesis,
    [--equal(codomain(compose(a,b)),domain(X)),
     --equal(compose(compose(a,b),X),Y),
     --equal(codomain(compose(a,b)),domain(Z)),
     --equal(compose(compose(a,b),Z),Y),
     ++equal(X,Z)]).

input_clause(codomain_of_a_equals_domain_of_b,hypothesis,
    [++equal(codomain(a),domain(b))]).

input_clause(codomain_of_b_equals_domain_of_h,hypothesis,
    [++equal(codomain(b),domain(h))]).

input_clause(codomain_of_b_equals_domain_of_g,hypothesis,
    [++equal(codomain(b),domain(g))]).

input_clause(bh_equals_bg,hypothesis,
    [++equal(compose(b,h),compose(b,g))]).

input_clause(prove_g_equals_h,theorem,
    [--equal(g,h)]).
%--------------------------------------------------------------------------
