%--------------------------------------------------------------------------
% File     : CAT003=Epim1-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Category Theory
% Problem  : XY epimorphism => X epimorphism
% Version  : [Mitchell, 1967] axioms.
% English  : If xy is an epimorphism, then x is an epimorphism.

% Refs     : Mitchell B. (1967), Theory of categories, (Pure and Applied 
%            Mathematics, Volume 17), Academic Press.
%          : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : C3 [McCharen, et al., 1976]
%          : p3.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   36 (   0 non-Horn)(  11 unit)
%            Number of literals          :   84 (  23 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :    9 (   6 constant)
%            Number of variables         :   91 (   5 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Mitchell's axioms for category theory 
include('Axioms/CAT001-0.ax').
include('Axioms/CAT001-0.eq').
%--------------------------------------------------------------------------
input_clause(ab_equals_c,hypothesis,
    [++product(a,b,c)]).

input_clause(cancellation_for_product,hypothesis,
    [--product(X,c,W),
     --product(Y,c,W),
     ++equal(X,Y)]).

input_clause(ha_equals_d,hypothesis,
    [++product(h,a,d)]).

input_clause(ga_equals_d,hypothesis,
    [++product(g,a,d)]).

input_clause(prove_h_equals_g,theorem,
    [--equal(h,g)]).

%----The ANL group use these extra lemmas as demodulators -
%input_clause(name,hypothesis,
%    [++equal(domain(domain(X)),domain(X))]).
%input_clause(name,hypothesis,
%    [++equal(codomain(domain(X)),domain(X))]).
%input_clause(name,hypothesis,
%    [++equal(domain(codomain(X)),codomain(X))]).
%input_clause(name,hypothesis,
%    [++equal(codomain(codomain(X)),codomain(X))]).
%input_clause(name,hypothesis,
%    [++equal(compose(codomain(X),X),X)]).
%input_clause(name,hypothesis,
%    [++equal(compose(X,domain(X)),X)]).
%input_clause(name,hypothesis,
%    [++equal(compose(codomain(X),codomain(X)),codomain(X))]).
%input_clause(name,hypothesis,
%    [++equal(compose(domain(X),domain(X)),domain(X))]).
%input_clause(name,hypothesis,
%    [++equal(domain(compose(X,Y)),domain(Y))]).
%input_clause(name,hypothesis,
%    [++equal(codomain(compose(X,Y)),codomain(X))]).
%--------------------------------------------------------------------------
