%--------------------------------------------------------------------------
% File     : CAT002=Monom2-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Category Theory
% Problem  : X and Y monomorphisms, XY well-defined => XY monomorphism
% Version  : [Quaife, 1989] (equality) axioms.
% English  : If x and y are monomorphisms and xy is well-defined then 
%            xy is a monomorphism.

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Quaife A. (1989), Email to Larry Wos 05/02/89.
% Source   : [ANL]
% Names    : C2 [McCharen, et al., 1976]
%          : p2.ver2.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   21 (   0 non-Horn)(  10 unit)
%            Number of literals          :   40 (  40 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    7 (   4 constant)
%            Number of variables         :   33 (   0 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Quaife's axioms for category theory 
include('Axioms/CAT002-0.ax').
%--------------------------------------------------------------------------
input_clause(codomain_of_a_equals_domain_of_b,hypothesis,
    [++equal(codomain(a),domain(b))]).

input_clause(monomorphism1,hypothesis,
    [--equal(codomain(X),domain(a)),
     --equal(compose(X,a),Y),
     --equal(codomain(Z),domain(b)),
     --equal(compose(Z,a),Y),
     ++equal(X,Z)]).

input_clause(monomorphism2,hypothesis,
    [--equal(codomain(X),domain(a)),
     --equal(compose(X,b),Y),
     --equal(codomain(Z),domain(b)),
     --equal(compose(Z,b),Y),
     ++equal(X,Z)]).

input_clause(codomain_of_h_equals_domain_of_ab,hypothesis,
    [++equal(codomain(h),domain(compose(a,b)))]).

input_clause(codomain_of_g_equals_domain_of_ab,hypothesis,
    [++equal(codomain(g),domain(compose(a,b)))]).

input_clause(h_ab_equals_g_ab,hypothesis,
    [++equal(compose(h,compose(a,b)),compose(g,compose(a,b)))]).

input_clause(prove_h_equals_g,theorem,
    [--equal(h,g)]).
%--------------------------------------------------------------------------
