%--------------------------------------------------------------------------
% File     : CAT002=Monom2-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Category Theory
% Problem  : X and Y monomorphisms, XY well-defined => XY monomorphism
% Version  : [Mitchell, 1967] axioms.
% English  : If x and y are monomorphisms and xy is well-defined then 
%            xy is a monomorphism.

% Refs     : Mitchell B. (1967), Theory of categories, (Pure and Applied 
%            Mathematics, Volume 17), Academic Press.
%          : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : C2 [McCharen, et al., 1976]
%          : p2.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   37 (   0 non-Horn)(  11 unit)
%            Number of literals          :   87 (  24 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :    9 (   6 constant)
%            Number of variables         :   94 (   5 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Mitchell's axioms for category theory 
include('Axioms/CAT001-0.ax').
include('Axioms/CAT001-0.eq').
%--------------------------------------------------------------------------
input_clause(cancellation_for_product1,hypothesis,
    [--product(a,X,W),
     --product(a,Y,W),
     ++equal(X,Y)]).

input_clause(cancellation_for_product2,hypothesis,
    [--product(b,X,W),
     --product(b,Y,W),
     ++equal(X,Y)]).

input_clause(ab_equals_c,hypothesis,
    [++product(a,b,c)]).

input_clause(ch_equals_d,hypothesis,
    [++product(c,h,d)]).

input_clause(cg_equals_d,hypothesis,
    [++product(c,g,d)]).

input_clause(prove_h_equals_g,theorem,
    [--equal(h,g)]).
%--------------------------------------------------------------------------
