%--------------------------------------------------------------------------
% File     : CAT001=Monom1-4 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Category Theory
% Problem  : XY monomorphism => Y monomorphism
% Version  : [Scott, 1979] axioms : Reduced > Complete.
% English  : If xy is a monomorphism, then y is a monomorphism.

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Scott D. (1979), Identity & Existence in Intuitionist Logic, 
%            In Fournam M.P. (Ed), Durham Proceedings Applications 
%            of Sheaves, (Lecture Notes in Mathematics Volume 753), 
%            660-696.
% Source   : [ANL]
% Names    : C1 [McCharen, et al., 1976]

% Status   : 
% Syntax   : Number of clauses           :   26 (   0 non-Horn)(   8 unit)
%            Number of literals          :   51 (  29 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    7 (   4 constant)
%            Number of variables         :   46 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : The dependent axioms have been removed.  The ANL version has 
%            been extended to use all axioms.
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Scott's axioms for category theory 
include('Axioms/CAT004-0.ax').
include('Axioms/CAT004-0.eq').
%--------------------------------------------------------------------------
input_clause(assume_ab_exists,hypothesis,
    [++there_exists(compose(a,b))]).

input_clause(monomorphism,hypothesis,
    [--equal(compose(compose(a,b),X),Y),
     --equal(compose(compose(a,b),Z),Y),
     ++equal(X,Z)]).

input_clause(assume_bh_exists,hypothesis,
    [++there_exists(compose(b,h))]).

input_clause(bh_equals_bg,hypothesis,
    [++equal(compose(b,h),compose(b,g))]).

input_clause(prove_h_equals_g,theorem,
    [--equal(h,g)]).
%--------------------------------------------------------------------------
