%--------------------------------------------------------------------------
% File     : CAT001=Monom1-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Category Theory
% Problem  : XY monomorphism => Y monomorphism
% Version  : [Quaife, 1989] (equality) axioms.
% English  : If xy is a monomorphism, then y is a monomorphism.

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Quaife A. (1989), Email to Larry Wos 05/02/89.
% Source   : [ANL]
% Names    : C1 [McCharen, et al., 1976]
%          : p1.ver2.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   20 (   0 non-Horn)(  10 unit)
%            Number of literals          :   35 (  35 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    7 (   4 constant)
%            Number of variables         :   30 (   0 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Quaife's axioms for category theory 
include('Axioms/CAT002-0.ax').
%--------------------------------------------------------------------------
input_clause(c1,hypothesis,
    [--equal(codomain(X),domain(compose(a,b))),
     --equal(compose(X,compose(a,b)),Y),
     --equal(codomain(Z),domain(compose(a,b))),
     --equal(compose(Z,compose(a,b)),Y),
     ++equal(X,Z)]).

input_clause(codomain_of_a_equals_domain_of_b,hypothesis,
    [++equal(codomain(a),domain(b))]).

input_clause(codomain_of_a_equals_domain_of_h,hypothesis,
    [++equal(codomain(a),domain(h))]).

input_clause(codomain_of_a_equals_domain_of_g,hypothesis,
    [++equal(codomain(a),domain(g))]).

input_clause(ah_equals_ag,hypothesis,
    [++equal(compose(a,h),compose(a,g))]).

input_clause(prove_h_equals_g,theorem,
    [--equal(h,g)]).
%--------------------------------------------------------------------------
