%--------------------------------------------------------------------------
% File     : CAT001=Monom1-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Category Theory
% Problem  : XY monomorphism => Y monomorphism
% Version  : [Mitchell, 1967] axioms.
% English  : If xy is a monomorphism, then y is a monomorphism.

% Refs     : Mitchell B. (1967), Theory of categories, (Pure and Applied 
%            Mathematics, Volume 17), Academic Press.
%          : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : C1 [McCharen, et al., 1976]
%          : p1.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   36 (   0 non-Horn)(  11 unit)
%            Number of literals          :   84 (  23 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :    9 (   6 constant)
%            Number of variables         :   91 (   5 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Mitchell's axioms for category theory 
include('Axioms/CAT001-0.ax').
include('Axioms/CAT001-0.eq').
%--------------------------------------------------------------------------
input_clause(ab_equals_c,hypothesis,
    [++product(a,b,c)]).

input_clause(cancellation_for_product,hypothesis,
    [--product(c,X1,X2),
     --product(c,X3,X2),
     ++equal(X1,X3)]).

input_clause(bh_equals_d,hypothesis,
    [++product(b,h,d)]).

input_clause(bg_equals_d,hypothesis,
    [++product(b,g,d)]).

input_clause(prove_h_equals_g,theorem,
    [--equal(h,g)]).
%--------------------------------------------------------------------------
