%--------------------------------------------------------------------------
% File     : BOO016=ProdSum-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Boolean Algebra
% Problem  : Relating product and sum (X * Y = Z -> X + Z = X)
% Version  : [McCharen, et al., 1976] axioms.
% English  : 

% Refs     : Whitesitt J.E. (1961), Boolean Algebra and Its Applications, 
%            Addison-Wesley, Chapter 2.
%          : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [McCharen, et al., 1976]
% Names    : Established lemma [McCharen, et al., 1976]

% Status   : 
% Syntax   : Number of clauses           :   38 (   0 non-Horn)(  13 unit)
%            Number of literals          :   96 (  24 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    8 (   5 constant)
%            Number of variables         :  126 (   0 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include boolean algebra axioms 
include('Axioms/BOO002-0.ax').
%----Include boolean algebra equality axioms 
include('Axioms/BOO002-0.eq').
%--------------------------------------------------------------------------
input_clause(x_times_y,hypothesis,
    [++product(x,y,z)]).

input_clause(prove_sum,theorem,
    [--sum(x,z,x)]).
%--------------------------------------------------------------------------
