%--------------------------------------------------------------------------
% File     : BOO015=DeMorgan2-2 : TPTP v1.1.1. Bugfixed v1.0.1.
% Domain   : Boolean Algebra
% Problem  : DeMorgan for inverse and sum (X^-1 + Y^-1) = (X * Y)^-1
% Version  : [ANL] (equality) axioms.
% English  : 

% Refs     : 
% Source   : [ANL]
% Names    : prob10.ver2.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   25 (   0 non-Horn)(  18 unit)
%            Number of literals          :   33 (  33 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    9 (   6 constant)
%            Number of variables         :   44 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
% Bugfixes : v1.0.1 - Clause a_inverse_plus_b_inverse_is_d fixed.
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include boolean algebra axioms for equality formulation 
include('Axioms/BOO003-0.ax').
%--------------------------------------------------------------------------
input_clause(a_times_b_is_c,hypothesis,
    [++equal(multiply(a,b),c)]).

input_clause(a_inverse_plus_b_inverse_is_d,hypothesis,
    [++equal(add(inverse(a),inverse(b)),d)]).

input_clause(prove_c_inverse_is_d,theorem,
    [--equal(inverse(c),d)]).
%--------------------------------------------------------------------------
