%--------------------------------------------------------------------------
% File     : BOO015=DeMorgan2-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Boolean Algebra
% Problem  : DeMorgan for inverse and sum (X^-1 + Y^-1) = (X * Y)^-1
% Version  : [McCharen, et al., 1976] axioms.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Veroff R. (1992), Email to Geoff Sutcliffe.
% Source   : [Veroff, 1992]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   39 (   0 non-Horn)(  14 unit)
%            Number of literals          :   97 (  25 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   10 (   7 constant)
%            Number of variables         :  126 (   0 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include boolean algebra axioms 
include('Axioms/BOO002-0.ax').
%----Include boolean algebra equality axioms 
include('Axioms/BOO002-0.eq').
%--------------------------------------------------------------------------
input_clause(x_times_y,hypothesis,
    [++product(x,y,x_times_z)]).

input_clause(x_inverse_plus_y_inverse,hypothesis,
    [++sum(inverse(x),inverse(y),x_inverse_plus_y_inverse)]).

input_clause(prove_equation,hypothesis,
    [--equal(inverse(x_times_y),x_inverse_plus_y_inverse)]).
%--------------------------------------------------------------------------
