%--------------------------------------------------------------------------
% File     : BOO014=DeMorgan1-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Boolean Algebra
% Problem  : DeMorgan for inverse and product (X+Y)^-1 = (X^-1) * (Y^-1)
% Version  : [McCharen, et al., 1976] axioms : Augmented.
% English  : 

% Refs     : Whitesitt J.E. (1961), Boolean Algebra and Its Applications, 
%            Addison-Wesley, Chapter 2.
%          : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [McCharen, et al., 1976]
% Names    : B10 [McCharen, et al., 1976]
%          : prob.10.ver1 [ANL]

% Status   : 
% Syntax   : Number of clauses           :   41 (   0 non-Horn)(  15 unit)
%            Number of literals          :  103 (  27 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   10 (   7 constant)
%            Number of variables         :  130 (   0 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include boolean algebra axioms 
include('Axioms/BOO002-0.ax').
%----Include boolean algebra equality axioms 
include('Axioms/BOO002-0.eq').
%--------------------------------------------------------------------------
input_clause(inverse_is_self_cancelling,axiom,
    [++equal(inverse(inverse(X)),X)]).

input_clause(inverse_is_unique,axiom,
    [--sum(X,Y,multiplicative_identity),
     --sum(X,Z,multiplicative_identity),
     --product(X,Y,additive_identity),
     --product(X,Z,additive_identity),
     ++equal(Y,Z)]).

input_clause(x_plus_y,hypothesis,
    [++sum(x,y,x_plus_z)]).

input_clause(x_inverse_times_y_inverse,hypothesis,
    [++product(inverse(x),inverse(y),x_inverse_times_y_inverse)]).

input_clause(prove_equation,theorem,
    [--equal(inverse(x_plus_y),x_inverse_times_y_inverse)]).
%--------------------------------------------------------------------------
