%--------------------------------------------------------------------------
% File     : BOO013=InvUnq-4 : TPTP v1.1.1. Bugfixed v1.1.0.
% Domain   : Boolean Algebra
% Problem  : The inverse of X is unique
% Version  : [Veroff, 1994] (equality) axioms.
% English  : 

% Refs     : Veroff R. (1994), Problem Set, AAR Newsletter 24, 8.
% Source   : [Veroff, 1994]
% Names    : TE [Veroff, 1994]

% Status   : 
% Syntax   : Number of clauses           :   19 (   0 non-Horn)(  12 unit)
%            Number of literals          :   27 (  27 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    7 (   4 constant)
%            Number of variables         :   34 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include boolean algebra axioms for equality formulation 
include('Axioms/BOO004-0.ax').
%--------------------------------------------------------------------------
input_clause(b_a_multiplicative_identity,hypothesis,
    [++equal(add(a,b),multiplicative_identity)]).

input_clause(b_an_additive_identity,hypothesis,
    [++equal(multiply(a,b),additive_identity)]).

input_clause(prove_a_inverse_is_b,theorem,
    [--equal(b,inverse(a))]).
%--------------------------------------------------------------------------
