%--------------------------------------------------------------------------
% File     : BOO013=InvUnq-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Boolean Algebra
% Problem  : The inverse of X is unique
% Version  : [McCharen, et al., 1976] axioms : Augmented.
% English  : 

% Refs     : Whitesitt J.E. (1961), Boolean Algebra and Its Applications, 
%            Addison-Wesley, Chapter 2.
%          : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [McCharen, et al., 1976]
% Names    : B9 [McCharen, et al., 1976]
%          : prob9.ver1 [ANL]

% Status   : 
% Syntax   : Number of clauses           :   42 (   0 non-Horn)(  17 unit)
%            Number of literals          :  100 (  26 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    8 (   5 constant)
%            Number of variables         :  127 (   0 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    3

% Comments : Inverse is an involution is added as a lemma.
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include boolean algebra axioms 
include('Axioms/BOO002-0.ax').
%----Include boolean algebra equality axioms 
include('Axioms/BOO002-0.eq').
%--------------------------------------------------------------------------
input_clause(inverse_is_an_involution,axiom,
    [++equal(inverse(inverse(X)),X)]).

input_clause(sum_to_multiplicative_identity1,hypothesis,
    [++sum(x,y,multiplicative_identity)]).

input_clause(sum_to_multiplicative_identity2,hypothesis,
    [++sum(x,z,multiplicative_identity)]).

input_clause(product_to_additive_identity1,hypothesis,
    [++product(x,y,additive_identity)]).

input_clause(product_to_additive_identity2,hypothesis,
    [++product(x,z,additive_identity)]).

input_clause(prove_both_inverse_are_equal,hypothesis,
    [--equal(y,z)]).
%--------------------------------------------------------------------------
