%--------------------------------------------------------------------------
% File     : BOO013=InvUnq-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Boolean Algebra
% Problem  : The inverse of X is unique
% Version  : [ANL] (equality) axioms.
% English  : 

% Refs     : 
% Source   : [ANL]
% Names    : prob9.ver2.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   27 (   0 non-Horn)(  20 unit)
%            Number of literals          :   35 (  35 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    9 (   6 constant)
%            Number of variables         :   44 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include boolean algebra axioms for equality formulation 
include('Axioms/BOO003-0.ax').
%--------------------------------------------------------------------------
input_clause(b_an_multiplicative_identity,hypothesis,
    [++equal(add(a,b),mulitplicative_identity)]).

input_clause(c_an_multiplicative_identity,hypothesis,
    [++equal(add(a,c),mulitplicative_identity)]).

input_clause(b_a_additive_identity,hypothesis,
    [++equal(multiply(a,b),additive_identity)]).

input_clause(c_a_additive_identity,hypothesis,
    [++equal(multiply(a,c),additive_identity)]).

input_clause(prove_b_is_a,theorem,
    [--equal(b,c)]).
%--------------------------------------------------------------------------
