%--------------------------------------------------------------------------
% File     : BOO012=InvIvln-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Boolean Algebra
% Problem  : Inverse is an involution
% Version  : [McCharen, et al., 1976] axioms : Augmented.
% English  : 

% Refs     : Whitesitt J.E. (1961), Boolean Algebra and Its Applications, 
%            Addison-Wesley, Chapter 2.
%          : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [McCharen, et al., 1976]
% Names    : B8 [McCharen, et al., 1976]
%          : prob8.ver1 [ANL]

% Status   : 
% Syntax   : Number of clauses           :   49 (   0 non-Horn)(  18 unit)
%            Number of literals          :  121 (  25 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    7 (   4 constant)
%            Number of variables         :  164 (   6 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include boolean algebra axioms 
include('Axioms/BOO002-0.ax').
%----Include boolean algebra equality axioms 
include('Axioms/BOO002-0.eq').
%--------------------------------------------------------------------------
input_clause(x_plus_x_is_x,axiom,
    [++sum(X,X,X)]).

input_clause(x_times_x_is_x,axiom,
    [++product(X,X,X)]).

input_clause(x_plus_multiplicative_identity,axiom,
    [++sum(X,multiplicative_identity,mulitplicative_identity)]).

input_clause(x_times_additive_identity,axiom,
    [++product(X,additive_identity,additive_identity)]).

input_clause(sum_product_dual1,axiom,
    [--product(X,Y,Z),
     ++sum(X,Z,X)]).

input_clause(sum_product_dual2,axiom,
    [--sum(X,Y,Z),
     ++product(X,Z,X)]).

input_clause(sum_and_mulitply,axiom,
    [++sum(X,multiply(X,Y),X)]).

input_clause(product_and_add,axiom,
    [++product(X,add(X,Y),X)]).

input_clause(associaticity_of_sum1,axiom,
    [--sum(X,Y,X_plus_Y),
     --sum(Y,Z,Y_plus_Z),
     --sum(X,Y_plus_Z,X_plus_Y_plus_Z),
     ++sum(X_plus_Y,Z,X_plus_Y_plus_Z)]).

input_clause(associaticity_of_sum2,axiom,
    [--sum(X,Y,X_plus_Y),
     --sum(Y,Z,Y_plus_Z),
     ++sum(X_plus_Y,Z,X_plus_Y_plus_Z),
     --sum(X,Y_plus_Z,X_plus_Y_plus_Z)]).

input_clause(associaticity_of_product1,axiom,
    [--product(X,Y,X_times_Y),
     --product(Y,Z,Y_times_Z),
     --product(X,Y_times_Z,X_times_Y_times_Z),
     ++product(X_times_Y,Z,X_times_Y_times_Z)]).

input_clause(associaticity_of_product2,axiom,
    [--product(X,Y,X_times_Y),
     --product(Y,Z,Y_times_Z),
     ++product(X_times_Y,Z,X_times_Y_times_Z),
     --product(X,Y_times_Z,X_times_Y_times_Z)]).

input_clause(prove_inverse_is_an_involution,theorem,
    [--equal(inverse(inverse(x)),x)]).
%--------------------------------------------------------------------------
