%--------------------------------------------------------------------------
% File     : BOO011=InvAId-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Boolean Algebra
% Problem  : Inverse of additive identity = Multiplicative identity
% Version  : [McCharen, et al., 1976] axioms.
% English  : The inverse of the additive identity is the multiplicative 
%            identity.

% Refs     : Whitesitt J.E. (1961), Boolean Algebra and Its Applications, 
%            Addison-Wesley, Chapter 2.
%          : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [McCharen, et al., 1976]
% Names    : B7 [McCharen, et al., 1976]
%          : prob7.ver1 [ANL]

% Status   : 
% Syntax   : Number of clauses           :   37 (   0 non-Horn)(  12 unit)
%            Number of literals          :   95 (  25 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    5 (   2 constant)
%            Number of variables         :  126 (   0 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include boolean algebra axioms 
include('Axioms/BOO002-0.ax').
%----Include boolean algebra equality axioms 
include('Axioms/BOO002-0.eq').
%--------------------------------------------------------------------------
input_clause(prove_equation,hypothesis,
    [--equal(inverse(additive_identity),multiplicative_identity)]).
%--------------------------------------------------------------------------
