%--------------------------------------------------------------------------
% File     : BOO008=SumAssc-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Boolean Algebra
% Problem  : Sum is associative ( (X + Y) + Z = X + (Y + Z) )
% Version  : [McCharen, et al., 1976] axioms.
% English  : 

% Refs     : Whitesitt J.E. (1961), Boolean Algebra and Its Applications, 
%            Addison-Wesley, Chapter 2.
%          : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Overbeek R., McCharen J., and Wos L. (1976), Complexity and 
%            Related Enhancements for Automated Theorem-Proving Programs, 
%            Computer and Mathematics with Applications 2, 1-16.
% Source   : [McCharen, et al., 1976]
% Names    : B1 [McCharen, et al., 1976]
%          : Theorem 4 [Overbeek, et al., 1976]
%          : prob1.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   41 (   0 non-Horn)(  16 unit)
%            Number of literals          :   99 (  25 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   12 (   9 constant)
%            Number of variables         :  126 (   0 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    2

% Comments : The problem boolean.lop [SETHEO] also does this problem.
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include boolean algebra axioms 
include('Axioms/BOO002-0.ax').
%----Include boolean algebra equality axioms 
include('Axioms/BOO002-0.eq').
%--------------------------------------------------------------------------
input_clause(y_plus_z,hypothesis,
    [++sum(y,z,y_plus_z)]).

input_clause(x_plus__y_plus_z,hypothesis,
    [++sum(x,y_plus_z,x__plus_y_plus_z)]).

input_clause(x_plus_y,hypothesis,
    [++sum(x,y,x_plus_y)]).

input_clause(x_plus_y__plus_z,hypothesis,
    [++sum(x_plus_y,z,x_plus_y__plus_z)]).

input_clause(prove_equality,theorem,
    [--equal(x__plus_y_plus_z,x_plus_y__plus_z)]).
%--------------------------------------------------------------------------
