%--------------------------------------------------------------------------
% File     : BOO007=ProdAssc-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Boolean Algebra
% Problem  : Product is associative ( (X * Y) * Z = X * (Y * Z) )
% Version  : [McCharen, et al., 1976] axioms.
% English  : 

% Refs     : Whitesitt J.E. (1961), Boolean Algebra and Its Applications, 
%            Addison-Wesley, Chapter 2.
%          : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Veroff R. (1992), Email to Geoff Sutcliffe.
% Source   : [Veroff, 1992]
% Names    : Established lemma [McCharen, et al., 1976]

% Status   : 
% Syntax   : Number of clauses           :   41 (   0 non-Horn)(  16 unit)
%            Number of literals          :   99 (  25 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   13 (  10 constant)
%            Number of variables         :  126 (   0 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    2

% Comments : The problem boolean.lop [SETHEO] also does this problem.
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include boolean algebra axioms 
include('Axioms/BOO002-0.ax').
%----Include boolean algebra equality axioms 
include('Axioms/BOO002-0.eq').
%--------------------------------------------------------------------------
input_clause(y_times_z,hypothesis,
    [++product(y,z,y_times_z)]).

input_clause(x_times__y_times_z,hypothesis,
    [++product(x,y_times_z,x__times_y_times_z)]).

input_clause(x_times_y,hypothesis,
    [++product(x,y,x_times_y)]).

input_clause(x_times_y__times_z,hypothesis,
    [++product(x_times_y,z,x_times_y__times_z)]).

input_clause(prove_equality,theorem,
    [--equal(x_times__y_times_z,x_times_y__times_z)]).
%--------------------------------------------------------------------------
