%--------------------------------------------------------------------------
% File     : BOO005=AddBnd-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Boolean Algebra
% Problem  : Addition is bounded (X + 1 = 1)
% Version  : [McCharen, et al., 1976] axioms.
% English  : 

% Refs     : Whitesitt J.E. (1961), Boolean Algebra and Its Applications, 
%            Addison-Wesley, Chapter 2.
%          : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Overbeek R., McCharen J., and Wos L. (1976), Complexity and 
%            Related Enhancements for Automated Theorem-Proving Programs, 
%            Computer and Mathematics with Applications 2, 1-16.
% Source   : [McCharen, et al., 1976]
% Names    : B3 part 1 [McCharen, et al., 1976]
%          : B5 [McCharen, et al., 1976]
%          : Lemma proved [Overbeek, et al., 1976]
%          : prob3_part1.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   37 (   0 non-Horn)(  12 unit)
%            Number of literals          :   95 (  24 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    6 (   3 constant)
%            Number of variables         :  126 (   0 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include boolean algebra axioms 
include('Axioms/BOO002-0.ax').
%----Include boolean algebra equality axioms 
include('Axioms/BOO002-0.eq').
%--------------------------------------------------------------------------
input_clause(prove_equations,theorem,
    [--sum(x,multiplicative_identity,multiplicative_identity)]).
%--------------------------------------------------------------------------
