%--------------------------------------------------------------------------
% File     : BOO002=B3LId-2 : TPTP v1.1.1. Bugfixed v1.1.0.
% Domain   : Boolean Algebra (Ternary)
% Problem  : In B3 algebra, X * X^-1 * Y = Y
% Version  : [OTTER] (equality) axioms : Reduced & Augmented > Incomplete.
% English  : 

% Refs     : Wos L. (1988), Automated Reasoning: 33 Basic Research 
%            Problems, Prentice-Hall.
% Source   : [Wos, 1988]
% Names    : Test Problem 13 [Wos, 1988]
%          : A Lemma for Axiom Independence [Wos, 1988]

% Status   : 
% Syntax   : Number of clauses           :   13 (   0 non-Horn)(   7 unit)
%            Number of literals          :   20 (  20 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    4 (   2 constant)
%            Number of variables         :   33 (   3 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : This version contains an extra lemma
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Don't include ternary Boolean algebra axioms, as one is omitted 
%include('axioms/BOO001-0.ax').
%--------------------------------------------------------------------------
input_clause(inverse_substitutivity1,axiom,
    [--equal(A,B),
     ++equal(inverse(A),inverse(B))]).

input_clause(multiply_substitutivity1,axiom,
    [--equal(C,D),
     ++equal(multiply(C,E,F),multiply(D,E,F))]).

input_clause(multiply_substitutivity2,axiom,
    [--equal(G,H),
     ++equal(multiply(I,G,J),multiply(I,H,J))]).

input_clause(multiply_substitutivity3,axiom,
    [--equal(K,L),
     ++equal(multiply(M,N,K),multiply(M,N,L))]).

input_clause(associativity,axiom,
    [++equal(multiply(multiply(V,W,X),Y,multiply(V,W,Z)),
multiply(V,W,multiply(X,Y,Z)))]).

input_clause(ternary_multiply_1,axiom,
    [++equal(multiply(Y,X,X),X)]).

input_clause(ternary_multiply_2,axiom,
    [++equal(multiply(X,X,Y),X)]).

input_clause(left_inverse,axiom,
    [++equal(multiply(inverse(Y),Y,X),X)]).

%----This axiom is omitted 
% input_clause(right_inverse,axiom,
%     [++equal(multiply(X,Y,inverse(Y)),X)]).

input_clause(extra_lemma,axiom,
    [++equal(multiply(X,Y,X),X)]).

input_clause(prove_equation,theorem,
    [--equal(multiply(a,inverse(a),b),b)]).
%--------------------------------------------------------------------------
