%--------------------------------------------------------------------------
% File     : BOO002=B3LId-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Boolean Algebra (Ternary)
% Problem  : In B3 algebra, X * X^-1 * Y = Y
% Version  : [OTTER] (equality) axioms : Reduced > Incomplete.
% English  : 

% Refs     : Lusk E., and Overbeek R. (1985), Reasoning about Equality, 
%            Journal of Automated Reasoning 1(2), 209-228.
%          : Overbeek R. (1990), ATP competition announced at CADE-10.
%          : Overbeek R. (1993), The CADE-11 Competitions: A Personal 
%            View, Journal of Automated Reasoning 11(3), 315-316.
%          : Lusk E.L., McCune W.W. (1993), Uniform Strategies: The 
%            CADE-11 Theorem Proving Contest, Journal of Automated 
%            Reasoning 11(3), 317-331.
%          : Zhang H. (1993), Automated Proofs of Equality Problems 
%            in Overbeek's Competition, Journal of Automated Reasoning 
%            11(3), 333-351.
% Source   : [Overbeek, 1990]
% Names    : Problem 5 [Lusk & Overbeek, 1985]
%          : Overbeek Competition Eq-3 [Overbeek, 1990]

% Status   : 
% Syntax   : Number of clauses           :   12 (   0 non-Horn)(   6 unit)
%            Number of literals          :   19 (  19 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    4 (   2 constant)
%            Number of variables         :   31 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Don't include ternary Boolean algebra axioms, as one is omitted 
% include('axioms/BOO001-0.ax').
%--------------------------------------------------------------------------
input_clause(inverse_substitutivity1,axiom,
    [--equal(A,B),
     ++equal(inverse(A),inverse(B))]).

input_clause(multiply_substitutivity1,axiom,
    [--equal(C,D),
     ++equal(multiply(C,E,F),multiply(D,E,F))]).

input_clause(multiply_substitutivity2,axiom,
    [--equal(G,H),
     ++equal(multiply(I,G,J),multiply(I,H,J))]).

input_clause(multiply_substitutivity3,axiom,
    [--equal(K,L),
     ++equal(multiply(M,N,K),multiply(M,N,L))]).

input_clause(associativity,axiom,
    [++equal(multiply(multiply(V,W,X),Y,multiply(V,W,Z)),
multiply(V,W,multiply(X,Y,Z)))]).

input_clause(ternary_multiply_1,axiom,
    [++equal(multiply(Y,X,X),X)]).

input_clause(ternary_multiply_2,axiom,
    [++equal(multiply(X,X,Y),X)]).

input_clause(left_inverse,axiom,
    [++equal(multiply(inverse(Y),Y,X),X)]).

%----This axiom is omitted 
% input_clause(right_inverse,axiom,
%     [++equal(multiply(X,Y,inverse(Y)),X)]).

input_clause(prove_equation,theorem,
    [--equal(multiply(a,inverse(a),b),b)]).
%--------------------------------------------------------------------------
