%--------------------------------------------------------------------------
% File     : ANA005=SumContFunc-4 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Analysis
% Problem  : The sum of two continuous functions is continuous
% Version  : [Bledsoe, 1990] axioms : Incomplete.
% English  : A lemma formed by adding in some resolvants and taking out 
%            the corresponding clauses.

% Refs     : Bledsoe W.W. (1990), Challenge Problems in Elementary 
%            Calculus, Journal of Automated Reasoning 6(3), 341-359.
%          : Bledsoe W.W. (1992), Email to Geoff Sutcliffe.
% Source   : [Bledsoe, 1992]
% Names    : Problem 4 [Bledsoe, 1990]
%          : p4.lop [SETHEO]

% Status   : 
% Syntax   : Number of clauses           :   24 (   4 non-Horn)(   6 unit)
%            Number of literals          :   48 (  14 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :   13 (   3 constant)
%            Number of variables         :   48 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    6

% Comments : Based on the theorem in calculus that the sum of two 
%            continuous functions is continuous.
%          : The TUM Problem Set provided some input to this problem.
%--------------------------------------------------------------------------
%----|X + Y| <= |X| + |Y|.
%----Clause 8 
input_clause(absolute_sum_less_or_equal_sum_of_absolutes1,axiom,
    [++less_or_equal(absolute(add(X,Y)),add(absolute(X),absolute(Y)))]).

%----Clause 9.1 
input_clause(minimum2,axiom,
    [++less_or_equal(minimum(X,Y),X)]).

%----Clause 9.2 
input_clause(minimum4,axiom,
    [--less_or_equal(X,Y),
     ++less_or_equal(X,minimum(X,Y))]).

%----Clause 10.1 
input_clause(minimum6,axiom,
    [++less_or_equal(minimum(X,Y),Y)]).

%----Clause 10.2 
input_clause(minimum8,axiom,
    [--less_or_equal(Y,X),
     ++less_or_equal(Y,minimum(X,Y))]).

%----Clause 11.3 
input_clause(less_or_equal_sum_of_halves,axiom,
    [--less_or_equal(X,half(Z)),
     --less_or_equal(Y,half(Z)),
     ++less_or_equal(add(X,Y),Z)]).

%----Clause 12 
input_clause(zero_and_half,axiom,
    [++less_or_equal(X,0),
     --less_or_equal(half(X),0)]).

%----Clause 14 
input_clause(commutativity_of_less_or_equal,axiom,
    [++less_or_equal(X,Y),
     ++less_or_equal(Y,X)]).

%----Clause 15 
input_clause(transitivity_of_less_or_equal,axiom,
    [--less_or_equal(X,Y),
     --less_or_equal(Y,Z),
     ++less_or_equal(X,Z)]).

%----Clause 15.1 omitted - it's the same as Clause 15 

%----Clause 16 
input_clause(commutativity_of_add,axiom,
    [++equal(add(X,Y),add(Y,X))]).

%----Clause 17 
input_clause(associativity_of_add,axiom,
    [++equal(add(add(X,Y),Z),add(X,add(Y,Z)))]).

%----Clause 20 = symmetry 
input_clause(symmetry,axiom,
    [--equal(X,Y),
     ++equal(Y,X)]).

%----Clause 21 = transitivity 
input_clause(transitivity,axiom,
    [--equal(X,Y),
     --equal(Y,Z),
     ++equal(X,Z)]).

%----Clause 22 
input_clause(less_or_equal_substitution1,axiom,
    [--equal(X,Z),
     --less_or_equal(X,Y),
     ++less_or_equal(Z,Y)]).

%----Clause 24 
input_clause(absolute_substitution,axiom,
    [--equal(X,Z),
     ++equal(absolute(X),absolute(Z))]).

%----Clause 25 
input_clause(add_substitution1,axiom,
    [--equal(X,Z),
     ++equal(add(X,Y),add(Z,Y))]).

%----Clause 26 
input_clause(add_substitution2,axiom,
    [--equal(Y,Z),
     ++equal(add(X,Y),add(X,Z))]).

%----Clause 1 
input_clause(clause_1,hypothesis,
    [++less_or_equal(Epsilon,0),
     --less_or_equal(delta_1(Epsilon),0)]).

%----Clause 2 
input_clause(clause_2,hypothesis,
    [++less_or_equal(Epsilon,0),
     --less_or_equal(delta_2(Epsilon),0)]).

%----Clause 3 
input_clause(clause_3,hypothesis,
    [++less_or_equal(Epsilon,0),
     --less_or_equal(absolute(add(Z,negate(a_real_number))),delta_1(Epsilon)),
     ++less_or_equal(absolute(add(f(Z),negate(f(a_real_number)))),Epsilon)]).

%----Clause 4 
input_clause(clause_4,hypothesis,
    [++less_or_equal(Epsilon,0),
     --less_or_equal(absolute(add(Z,negate(a_real_number))),delta_2(Epsilon)),
     ++less_or_equal(absolute(add(g(Z),negate(g(a_real_number)))),Epsilon)]).

%----Clause 5 
input_clause(clause_5,hypothesis,
    [--less_or_equal(epsilon_0,0)]).

%----Clause 6 
input_clause(clause_6,hypothesis,
    [++less_or_equal(Delta,0),
     ++less_or_equal(absolute(add(xs(Delta),negate(a_real_number))),Delta)]).

%----Clause 7 
input_clause(clause_7,theorem,
    [++less_or_equal(Delta,0),
     --less_or_equal(absolute(add(add(f(xs(Delta)),g(xs(Delta))),
add(negate(f(a_real_number)),negate(g(a_real_number))))),epsilon_0)]).
%--------------------------------------------------------------------------
