%--------------------------------------------------------------------------
% File     : ANA005=SumContFunc-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Analysis
% Problem  : The sum of two continuous functions is continuous
% Version  : [McCharen, et al., 1976] axioms :
%            Incomplete > Augmented > Complete.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : BL3 [McCharen, et al., 1976]

% Status   : 
% Syntax   : Number of clauses           :   38 (   0 non-Horn)(   8 unit)
%            Number of literals          :   78 (  37 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :   15 (   5 constant)
%            Number of variables         :   75 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    6

% Comments : No natural language descriptions are available.
%          : Contributed to the ANL library by Woody Bledsoe.
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include limits axioms 
include('Axioms/ANA001-0.ax').
%----Include equality axioms for limits axioms 
include('Axioms/ANA001-0.eq').
%--------------------------------------------------------------------------
%----Equality substitution axioms 
input_clause(absolute_substitutivity1,axiom,
    [--equal(A,B),
     ++equal(absolute(A),absolute(B))]).

input_clause(f_substitutivity1,axiom,
    [--equal(C,D),
     ++equal(f(C),f(D))]).

input_clause(fp31_substitutivity1,axiom,
    [--equal(E,F),
     ++equal(fp31(E),fp31(F))]).

input_clause(fp32_substitutivity1,axiom,
    [--equal(G,H),
     ++equal(fp32(G),fp32(H))]).

input_clause(fp33_substitutivity1,axiom,
    [--equal(I,J),
     ++equal(fp33(I),fp33(J))]).

input_clause(g_substitutivity1,axiom,
    [--equal(K,L),
     ++equal(g(K),g(L))]).

%----Clauses from the theorem 
input_clause(c_10,theorem,
    [--less_than(0,X),
     ++less_than(0,fp31(X))]).

input_clause(c_11,theorem,
    [--less_than(0,X),
     --less_than(absolute(add(Y,minus(a))),fp31(X)),
     ++less_than(absolute(add(f(Y),minus(l1))),X)]).

input_clause(c_12,theorem,
    [--less_than(0,X),
     ++less_than(0,fp32(X))]).

input_clause(c_13,theorem,
    [--less_than(0,X),
     --less_than(absolute(add(Y,minus(a))),fp32(X)),
     ++less_than(absolute(add(g(Y),minus(l2))),X)]).

input_clause(c_14,theorem,
    [++less_than(0,b)]).

input_clause(c_15,theorem,
    [--less_than(0,X),
     ++less_than(absolute(add(fp33(X),minus(a))),X)]).

input_clause(c_16,theorem,
    [--less_than(0,X),
     --less_than(absolute(add(add(f(fp33(X)),g(fp33(X))),
minus(add(l1,l2)))),b)]).
%--------------------------------------------------------------------------
