%--------------------------------------------------------------------------
% File     : ANA004=SumContFuncLem2-4 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Analysis
% Problem  : Lemma 2 for the sum of two continuous functions is continuous
% Version  : [Bledsoe, 1990] axioms : Incomplete.
% English  : A lemma formed by adding in some resolvants and taking out 
%            the corresponding clauses.

% Refs     : Bledsoe W.W. (1990), Challenge Problems in Elementary 
%            Calculus, Journal of Automated Reasoning 6(3), 341-359.
%          : Bledsoe W.W. (1992), Email to Geoff Sutcliffe.
% Source   : [Bledsoe, 1992]
% Names    : Problem 2 [Bledsoe, 1990]
%          : p2.lop [SETHEO]

% Status   : 
% Syntax   : Number of clauses           :   13 (   4 non-Horn)(   1 unit)
%            Number of literals          :   29 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :   13 (   3 constant)
%            Number of variables         :   23 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    6

% Comments : Based on the theorem in calculus that the sum of two 
%            continuous functions is continuous.
%          : The TUM Problem Set provided some input to this problem.
%--------------------------------------------------------------------------
%----Clause 8.1 
input_clause(absolute_sum_less_or_equal_sum_of_absolutes2,axiom,
    [--less_or_equal(add(absolute(X),absolute(Y)),Z),
     ++less_or_equal(absolute(add(X,Y)),Z)]).

%----Clause 9.11 
input_clause(minimum3,axiom,
    [--less_or_equal(Z,minimum(X,Y)),
     ++less_or_equal(Z,X)]).

%----Clause 10.11 
input_clause(minimum7,axiom,
    [--less_or_equal(Z,minimum(X,Y)),
     ++less_or_equal(Z,Y)]).

%----Clause 10.3 
input_clause(minimum9,axiom,
    [++less_or_equal(X,0),
     ++less_or_equal(Y,0),
     --less_or_equal(minimum(X,Y),0)]).

%----Clause 11.3 
input_clause(less_or_equal_sum_of_halves,axiom,
    [--less_or_equal(X,half(Z)),
     --less_or_equal(Y,half(Z)),
     ++less_or_equal(add(X,Y),Z)]).

%----Clause 12 
input_clause(zero_and_half,axiom,
    [++less_or_equal(X,0),
     --less_or_equal(half(X),0)]).

%----Clause 1 
input_clause(clause_1,hypothesis,
    [++less_or_equal(Epsilon,0),
     --less_or_equal(delta_1(Epsilon),0)]).

%----Clause 2 
input_clause(clause_2,hypothesis,
    [++less_or_equal(Epsilon,0),
     --less_or_equal(delta_2(Epsilon),0)]).

%----Clause 3 
input_clause(clause_3,hypothesis,
    [++less_or_equal(Epsilon,0),
     --less_or_equal(absolute(add(Z,negate(a_real_number))),
delta_1(Epsilon)),
     ++less_or_equal(absolute(add(f(Z),negate(f(a_real_number)))),
Epsilon)]).

%----Clause 4 
input_clause(clause_4,hypothesis,
    [++less_or_equal(Epsilon,0),
     --less_or_equal(absolute(add(Z,negate(a_real_number))),
delta_2(Epsilon)),
     ++less_or_equal(absolute(add(g(Z),negate(g(a_real_number)))),
Epsilon)]).

%----Clause 5 
input_clause(clause_5,hypothesis,
    [--less_or_equal(epsilon_0,0)]).

%----Clause 6 
input_clause(clause_6,hypothesis,
    [++less_or_equal(Delta,0),
     ++less_or_equal(absolute(add(xs(Delta),negate(a_real_number))),
Delta)]).

%----Clause 7_1 
input_clause(clause_7_1,theorem,
    [++less_or_equal(Delta,0),
     --less_or_equal(absolute(add(add(f(xs(Delta)),
negate(f(a_real_number))),
add(g(xs(Delta)),negate(g(a_real_number))))),epsilon_0)]).
%--------------------------------------------------------------------------
