%--------------------------------------------------------------------------
% File     : ANA003=SumContFuncLem1-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Analysis
% Problem  : Lemma 1 for the sum of two continuous functions is continuous
% Version  : [Bledsoe, 1990] axioms : Incomplete > Augmented > Complete.
% English  : A lemma formed by adding in some resolvants and taking out 
%            the corresponding clauses.

% Refs     : Bledsoe W.W. (1990), Challenge Problems in Elementary 
%            Calculus, Journal of Automated Reasoning 6(3), 341-359.
%          : Bledsoe W.W. (1992), Email to Geoff Sutcliffe.
% Source   : [Bledsoe, 1992]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   50 (   5 non-Horn)(  13 unit)
%            Number of literals          :   96 (  38 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :   13 (   3 constant)
%            Number of variables         :  107 (   4 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    6

% Comments : Based on the theorem in calculus that the sum of two 
%            continuous functions is continuous.
%          : The TUM Problem Set provided some input to this problem.
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include axioms for limits 
include('Axioms/ANA002-0.ax').
%----Include missing equality axioms for a full axiomatisation 
include('Axioms/ANA002-0.eq').
%--------------------------------------------------------------------------
%----Clause 1 
input_clause(clause_1,hypothesis,
    [++less_or_equal(Epsilon,0),
     --less_or_equal(delta_1(Epsilon),0)]).

%----Clause 2 
input_clause(clause_2,hypothesis,
    [++less_or_equal(Epsilon,0),
     --less_or_equal(delta_2(Epsilon),0)]).

%----Clause 3 
input_clause(clause_3,hypothesis,
    [++less_or_equal(Epsilon,0),
     --less_or_equal(absolute(add(Z,negate(a_real_number))),
delta_1(Epsilon)),
     ++less_or_equal(absolute(add(f(Z),negate(f(a_real_number)))),
Epsilon)]).

%----Clause 4 
input_clause(clause_4,hypothesis,
    [++less_or_equal(Epsilon,0),
     --less_or_equal(absolute(add(Z,negate(a_real_number))),
delta_2(Epsilon)),
     ++less_or_equal(absolute(add(g(Z),negate(g(a_real_number)))),
Epsilon)]).

%----Clause 5 
input_clause(clause_5,hypothesis,
    [--less_or_equal(epsilon_0,0)]).

%----Clause 6 
input_clause(clause_6,hypothesis,
    [++less_or_equal(Delta,0),
     ++less_or_equal(absolute(add(xs(Delta),negate(a_real_number))),
Delta)]).

%----Clause 7_2 
input_clause(clause_7_2,theorem,
    [++less_or_equal(Delta,0),
     --less_or_equal(add(absolute(add(f(xs(Delta)),
negate(f(a_real_number)))),
absolute(add(g(xs(Delta)),negate(g(a_real_number))))),epsilon_0)]).
%--------------------------------------------------------------------------
