%--------------------------------------------------------------------------
% File     : ANA003=SumContFuncLem1-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Analysis
% Problem  : Lemma 1 for the sum of two continuous functions is continuous
% Version  : [McCharen, et al., 1976] axioms : Incomplete.
% English  : A lemma formed by adding in some resolvants and taking out 
%            the corresponding clauses.

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : BL1 [McCharen, et al., 1976]
%          : prob1.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   17 (   0 non-Horn)(   4 unit)
%            Number of literals          :   37 (   2 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :   15 (   5 constant)
%            Number of variables         :   27 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    6

% Comments : No natural language descriptions are available.
%          : Contributed to the ANL library by Woody Bledsoe.
%--------------------------------------------------------------------------
%----Axiom 1 
input_clause(right_identity,axiom,
    [++equal(add(X,0),X)]).

input_clause(left_identity,axiom,
    [++equal(add(0,X),X)]).

input_clause(reflexivity_of_less_than,axiom,
    [--less_than(X,X)]).

input_clause(transitivity_of_less_than,axiom,
    [--less_than(X,Y),
     --less_than(Y,Z),
     ++less_than(X,Z)]).

%----Axiom 2 
input_clause(axiom_2_1,axiom,
    [--less_than(0,X),
     --less_than(0,Y),
     ++less_than(0,minimum(X,Y))]).

input_clause(axiom_2_2,axiom,
    [--less_than(0,X),
     --less_than(0,Y),
     ++less_than(minimum(X,Y),X)]).

input_clause(axiom_2_3,axiom,
    [--less_than(0,X),
     --less_than(0,Y),
     ++less_than(minimum(X,Y),Y)]).

%----Axiom 3 
input_clause(axiom_3,axiom,
    [--less_than(X,half(Xa)),
     --less_than(Y,half(Xa)),
     ++less_than(add(X,Y),Xa)]).

%----Axiom 4 
input_clause(c_17,axiom,
    [--less_than(add(absolute(X),absolute(Y)),Xa),
     ++less_than(absolute(add(X,Y)),Xa)]).

%----Axiom 7 
input_clause(axiom_7,axiom,
    [--less_than(0,Xa),
     ++less_than(0,half(Xa))]).

%----Clauses from the problem.
%----Theorem clauses 
input_clause(c_10,theorem,
    [--less_than(0,X),
     ++less_than(0,fp31(X))]).

input_clause(c_11,theorem,
    [--less_than(0,X),
     --less_than(absolute(add(Y,minus(a))),fp31(X)),
     ++less_than(absolute(add(f(Y),minus(l1))),X)]).

input_clause(c_12,theorem,
    [--less_than(0,X),
     ++less_than(0,fp32(X))]).

input_clause(c_13,theorem,
    [--less_than(0,X),
     --less_than(absolute(add(Y,minus(a))),fp32(X)),
     ++less_than(absolute(add(g(Y),minus(l2))),X)]).

input_clause(c_14,theorem,
    [++less_than(0,b)]).

input_clause(c_15,theorem,
    [--less_than(0,X),
     ++less_than(absolute(add(fp33(X),minus(a))),X)]).

input_clause(c_16,theorem,
    [--less_than(0,X),
     --less_than(add(absolute(add(f(fp33(X)),minus(l1))),
absolute(add(g(fp33(X)),minus(l2)))),b)]).
%--------------------------------------------------------------------------
