%--------------------------------------------------------------------------
% File     : ANA003=SumContFuncLem1-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Analysis
% Problem  : Lemma 1 for the sum of two continuous functions is continuous
% Version  : [McCharen, et al., 1976] axioms :
%            Incomplete > Augmented > Complete.
% English  : A lemma formed by adding in some resolvants and taking out 
%            the corresponding clauses.

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : prob1.ver2.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   38 (   0 non-Horn)(   8 unit)
%            Number of literals          :   78 (  37 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :   15 (   5 constant)
%            Number of variables         :   75 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    6

% Comments : No natural language descriptions are available.
%          : Contributed to the ANL library by Woody Bledsoe.
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include limits axioms 
include('Axioms/ANA001-0.ax').
%----Include equality axioms for limits axioms 
include('Axioms/ANA001-0.eq').
%--------------------------------------------------------------------------
%----Substitution axioms 
input_clause(absolute_substitution1,axiom,
    [--equal(X,Y),
     ++equal(absolute(X),absolute(Y))]).

input_clause(f_substitution1,axiom,
    [--equal(X,Y),
     ++equal(f(X),f(Y))]).

input_clause(g_substitution1,axiom,
    [--equal(X,Y),
     ++equal(g(X),g(Y))]).

input_clause(fp31_substitution1,axiom,
    [--equal(X,Y),
     ++equal(fp31(X),fp31(Y))]).

input_clause(fp32_substitution1,axiom,
    [--equal(X,Y),
     ++equal(fp32(X),fp32(Y))]).

input_clause(fp32_substitution2,axiom,
    [--equal(X,Y),
     ++equal(fp33(X),fp33(Y))]).

%----Theorem clauses 
input_clause(c_10,theorem,
    [--less_than(0,X),
     ++less_than(0,fp31(X))]).

input_clause(c_11,theorem,
    [--less_than(0,X),
     --less_than(absolute(add(Y,minus(a))),fp31(X)),
     ++less_than(absolute(add(f(Y),minus(l1))),X)]).

input_clause(c_12,theorem,
    [--less_than(0,X),
     ++less_than(0,fp32(X))]).

input_clause(c_13,theorem,
    [--less_than(0,X),
     --less_than(absolute(add(Y,minus(a))),fp32(X)),
     ++less_than(absolute(add(g(Y),minus(l2))),X)]).

input_clause(c_14,theorem,
    [++less_than(0,b)]).

input_clause(c_15,theorem,
    [--less_than(0,X),
     ++less_than(absolute(add(fp33(X),minus(a))),X)]).

input_clause(c_16,theorem,
    [--less_than(0,X),
     --less_than(add(absolute(add(f(fp33(X)),minus(l1))),
absolute(add(g(fp33(X)),minus(l2)))),b)]).
%--------------------------------------------------------------------------
