%--------------------------------------------------------------------------
% File     : ANA002=IntmedVal-4 : TPTP v1.1.1. Bugfixed v1.1.0.
% Domain   : Analysis
% Problem  : Intermediate value theorem
% Version  : [Wang & Bledsoe, 1987] axioms.
%            Theorem formulation : Ground form of goal.
% English  : If a function f is continuous in a real closed interval 
%            [a,b], where f(a)<=0 and 0<=f(b), then there exists X such 
%            that f(X) = 0.

% Refs     : Wang T-C., Bledsoe W.W. (1987), Hierarchical Deduction, 
%            Journal of Automated Reasoning 3(1), 35-77.
% Source   : [Wang & Bledsoe, 1987]
% Names    : ivt.lop [SETHEO]

% Status   : 
% Syntax   : Number of clauses           :   17 (   5 non-Horn)(   4 unit)
%            Number of literals          :   44 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    9 (   4 constant)
%            Number of variables         :   20 (   0 singleton)
%            Maximal clause size         :    6
%            Maximal term depth          :    3

% Comments : The l comes from an instantiation of the least-up-bound 
%            axiom, which says that there exists a point l such that f(l) 
%            = 0.
%--------------------------------------------------------------------------
%----Inequality axioms 
input_clause(reflexivity_of_less,axiom,
    [++less_than_or_equal(X,X)]).

input_clause(totality_of_less,axiom,
    [++less_than_or_equal(X,Y),
     ++less_than_or_equal(Y,X)]).

input_clause(transitivity_of_less,axiom,
    [++less_than_or_equal(X,Z),
     --less_than_or_equal(X,Y),
     --less_than_or_equal(Y,Z)]).

%----Interpolation axioms 
input_clause(interpolation1,axiom,
    [--less_than_or_equal(X,q(Y,X)),
     ++less_than_or_equal(X,Y)]).

input_clause(interpolation2,axiom,
    [--less_than_or_equal(q(X,Y),X),
     ++less_than_or_equal(Y,X)]).

%----Continuity axioms 
input_clause(continuity1,axiom,
    [++less_than_or_equal(f(X),0),
     --less_than_or_equal(X,h(X)),
     --less_than_or_equal(lower_bound,X),
     --less_than_or_equal(X,upper_bound)]).

input_clause(continuity2,axiom,
    [++less_than_or_equal(f(X),0),
     --less_than_or_equal(Y,X),
     --less_than_or_equal(f(Y),0),
     ++less_than_or_equal(Y,h(X)),
     --less_than_or_equal(lower_bound,X),
     --less_than_or_equal(X,upper_bound)]).

input_clause(continuity3,axiom,
    [++less_than_or_equal(0,f(X)),
     --less_than_or_equal(k(X),X),
     --less_than_or_equal(lower_bound,X),
     --less_than_or_equal(X,upper_bound)]).

input_clause(continuity4,axiom,
    [++less_than_or_equal(0,f(X)),
     --less_than_or_equal(X,Y),
     --less_than_or_equal(0,f(Y)),
     ++less_than_or_equal(k(X),Y),
     --less_than_or_equal(lower_bound,X),
     --less_than_or_equal(X,upper_bound)]).

%----Least upper bound axioms 
input_clause(crossover1,axiom,
    [++less_than_or_equal(X,l),
     --less_than_or_equal(X,upper_bound),
     --less_than_or_equal(f(X),0)]).

input_clause(crossover2_and_g_function1,axiom,
    [++less_than_or_equal(g(X),upper_bound),
     ++less_than_or_equal(l,X)]).

input_clause(crossover3_and_g_function2,axiom,
    [++less_than_or_equal(f(g(X)),0),
     ++less_than_or_equal(l,X)]).

input_clause(crossover4_and_g_function3,axiom,
    [--less_than_or_equal(g(X),X),
     ++less_than_or_equal(l,X)]).

%----Endpoints of the interval 
input_clause(the_interval,hypothesis,
    [++less_than_or_equal(lower_bound,upper_bound)]).

input_clause(lower_mapping,hypothesis,
    [++less_than_or_equal(f(lower_bound),0)]).

input_clause(upper_mapping,hypothesis,
    [++less_than_or_equal(0,f(upper_bound))]).

input_clause(prove_there_is_x_which_crosses,theorem,
    [--less_than_or_equal(f(l),0),
     --less_than_or_equal(0,f(l))]).
%--------------------------------------------------------------------------
