%--------------------------------------------------------------------------
% File     : ANA001=MinVal-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Analysis
% Problem  : Attaining minimum (or maximum) value
% Version  : [Wang & Bledsoe, 1987] axioms.
% English  : A continuous function f in a closed real interval [a,b] 
%            attains its minimum (or maximum) in this interval.

% Refs     : Wang T-C., Bledsoe W.W. (1987), Hierarchical Deduction, 
%            Journal of Automated Reasoning 3(1), 35-77.
% Source   : [Wang & Bledsoe, 1987]
% Names    : am8 [Wang & Bledsoe, 1987]

% Status   : 
% Syntax   : Number of clauses           :   18 (   3 non-Horn)(   3 unit)
%            Number of literals          :   41 (   0 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    7 (   3 constant)
%            Number of variables         :   23 (   0 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
input_clause(refelxivity,axiom,
    [++less_than_or_equal(X,X)]).

input_clause(totality,axiom,
    [++less_than_or_equal(X,Y),
     ++less_than_or_equal(Y,X)]).

input_clause(transitivity,axiom,
    [++less_than_or_equal(X,Z),
     --less_than_or_equal(X,Y),
     --less_than_or_equal(Y,Z)]).

input_clause(function,hypothesis,
    [++less_than_or_equal(f(X),f(Y)),
     --less_than_or_equal(X,Y),
     --less_than_or_equal(Y,X)]).

input_clause(in_interval,hypothesis,
    [++in_interval(Lower,X,Upper),
     --less_than_or_equal(Lower,X),
     --less_than_or_equal(X,Upper)]).

input_clause(interval1,hypothesis,
    [++less_than_or_equal(lower_bound,extreme_point)]).

input_clause(interval2,hypothesis,
    [++less_than_or_equal(extreme_point,upper_bound)]).

input_clause(below_extreme_point,hypothesis,
    [++less_than_or_equal(f(extreme_point),f(X)),
     --in_interval(lower_bound,X,extreme_point)]).

input_clause(q_function1,hypothesis,
    [++less_than_or_equal(X,extreme_point),
     --in_interval(lower_bound,X,upper_bound),
     ++less_than_or_equal(lower_bound,q(X))]).

input_clause(q_function2,hypothesis,
    [++less_than_or_equal(X,extreme_point),
     --in_interval(lower_bound,X,upper_bound),
     --less_than_or_equal(f(X),q(X))]).

input_clause(q_function3,hypothesis,
    [++less_than_or_equal(X,extreme_point),
     --in_interval(lower_bound,X,upper_bound),
     ++less_than_or_equal(q(X),X)]).

input_clause(h_function1,hypothesis,
    [++less_than_or_equal(lower_bound,h(X)),
     --in_interval(lower_bound,X,upper_bound)]).

input_clause(h_function2,hypothesis,
    [++less_than_or_equal(h(X),upper_bound),
     --in_interval(lower_bound,X,upper_bound)]).

input_clause(h_function3,hypothesis,
    [++less_than_or_equal(f(h(X)),f(X)),
     --in_interval(lower_bound,X,upper_bound)]).

input_clause(h_function4,hypothesis,
    [++less_than_or_equal(h(X),Y),
     --in_interval(lower_bound,X,upper_bound),
     --in_interval(lower_bound,Y,upper_bound),
     --less_than_or_equal(f(Y),f(X))]).

input_clause(k_function1,hypothesis,
    [--in_interval(lower_bound,X,upper_bound),
     ++less_than_or_equal(lower_bound,k(X))]).

input_clause(k_function2,hypothesis,
    [--in_interval(lower_bound,X,upper_bound),
     ++less_than_or_equal(k(X),upper_bound)]).

input_clause(prove_something,theorem,
    [--less_than_or_equal(f(X),f(k(X))),
     --in_interval(lower_bound,X,upper_bound)]).
%--------------------------------------------------------------------------
