%--------------------------------------------------------------------------
% File     : ALG002=OrdField-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : General Algebra
% Problem  : In an ordered field, if X > 0 then X^-1 > 0
% Version  : [Fleisig, et al., 1974] axioms.
% English  : 

% Refs     : Fleisig S., Loveland D.W., Smiley A.K., and Yarmush D.L. 
%            (1974), An Implementation of the Model Elimination Proof 
%            Procedure, In Journal of the ACM 21(1), ACM Press, New York, 
%            NY, 124-139.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : Example 5 [Fleisig, et al., 1974]
%          : EX5-T? [Wilson & Minker, 1976]
%          : ex5.lop [SETHEO]
%          : FEX5 [SPRFN]

% Status   : 
% Syntax   : Number of clauses           :   14 (   2 non-Horn)(   4 unit)
%            Number of literals          :   28 (   0 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    5 (   3 constant)
%            Number of variables         :   23 (   1 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
input_clause(right_identity,axiom,
    [++product(X,multiplicative_identity,X)]).

input_clause(not_abelian,axiom,
    [--product(multiplicative_identity,multiplicative_identity,
additive_identity)]).

input_clause(product_of_inverses1,axiom,
    [--product(X,Y,Z),
     ++product(additive_inverse(X),additive_inverse(Y),Z)]).

input_clause(product_of_inverses2,axiom,
    [++product(X,Y,Z),
     --product(additive_inverse(X),additive_inverse(Y),Z)]).

input_clause(product_to_inverse,axiom,
    [--product(X,Y,Z),
     ++product(X,additive_inverse(Y),additive_inverse(Z))]).

input_clause(inverse_and_identity,axiom,
    [++product(X,multiplicative_inverse(X),multiplicative_identity),
     ++product(X,X,additive_identity)]).

input_clause(inverse_greater_than_0,axiom,
    [--greater_than_0(X),
     --greater_than_0(additive_inverse(X))]).

input_clause(greater_than_0_square,axiom,
    [--greater_than_0(X),
     --product(X,X,additive_identity)]).

input_clause(commutativity_of_product,axiom,
    [--product(X,Y,Z),
     ++product(Y,X,Z)]).

input_clause(product_and_inverse,axiom,
    [++greater_than_0(X),
     ++product(X,X,additive_identity),
     ++greater_than_0(additive_inverse(X))]).

input_clause(square_to_0,axiom,
    [--product(Y,Z,X),
     --product(Y,Y,additive_identity),
     ++product(X,X,additive_identity)]).

input_clause(product_and_greater_than_0,axiom,
    [--product(Y,Z,X),
     --greater_than_0(Y),
     --greater_than_0(Z),
     ++greater_than_0(X)]).

input_clause(a_greater_than_0,hypothesis,
    [++greater_than_0(a)]).

input_clause(prove_a_inverse_greater_than_0,theorem,
    [--greater_than_0(multiplicative_inverse(a))]).
%--------------------------------------------------------------------------
