%--------------------------------------------------------------------------
% File     : ALG001=CmpsnHomoms-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : General Algebra
% Problem  : The composition of homomorphisms is a homomorphism
% Version  : [Boyer, et al., 1986] axioms.
% English  : 

% Refs     : Boyer R., Lusk E., McCune W., Overbeek R., Stickel M. and 
%            Wos L. (1986), Set Theory in First-Order Logic: Clauses for 
%            Godel's Axioms,  Journal of Automated Reasoning 2(3) 87-327.
%          : Wos L. (1988), Automated Reasoning: 33 Basic Research 
%            Problems, Prentice-Hall.
% Source   : [Boyer, et al., 1986]
% Names    : Problem 221-223 [Boyer, et al., 1986]
%          : Test Problem 15 [Wos, 1988]
%          : Composition of Homomorphisms [Wos, 1988]

% Status   : 
% Syntax   : Number of clauses           :  269 (  20 non-Horn)(  15 unit)
%            Number of literals          :  632 ( 273 equality)
%            Number of predicate symbols :   14 (   0 propositional)
%            Number of function symbols  :   67 (  14 constant)
%            Number of variables         :  732 (  28 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Godel's set axioms 
include('Axioms/SET003-0.ax').
%----Include the equality axioms for Godel's set axioms 
include('Axioms/SET003-0.eq').
%--------------------------------------------------------------------------
input_clause(one_homomorphism,hypothesis,
    [++homomorphism(f60,f62,f63,f64,f65)]).

input_clause(another_homomorphism,hypothesis,
    [++homomorphism(f61,f64,f65,f66,f67)]).

input_clause(prove_composition_is_a_homomorphism,theorem,
    [--homomorphism(composition(f60,f61),f62,f63,f66,f67)]).
%--------------------------------------------------------------------------
