%--------------------------------------------------------------------------
% File     : SET004=NBG_BAlgSubs-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory (Boolean Algebra definitions)
% Axioms   : Substitution axioms for set theory (Boolean algebra) axioms
% Version  : [Quaife, 1992a] axioms.
% English  : 

% Refs     : Quaife A. (1992a), Automated Deduction in von 
%            Neumann-Bernays-Godel Set Theory, In Journal of Automated 
%            Reasoning 8(1), 91-147.
%          : Quaife A. (1992b), Email to Geoff Sutcliffe.
% Source   : [Quaife, 1992b]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :    7 (   0 non-Horn)(   0 units)
%            Number of literals          :   17 (  11 equality)
%            Number of predicate symbols :    2 (   0 propositions)
%            Number of function symbols  :    4 (   0 constants)
%            Number of variables         :   20 (   0 singletons)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : Not all of these definitions appear in [Quaife, 1992a]. Some 
%            were extracted from [Quaife, 1992b]
%--------------------------------------------------------------------------
input_clause(compose_class_substitution1,axiom,
    [--equal(L,M),
     ++equal(compose_class(L),compose_class(M))]).

input_clause(single_valued1_substitution1,axiom,
    [--equal(N2,O2),
     ++equal(single_valued1(N2),single_valued1(O2))]).

input_clause(single_valued2_substitution1,axiom,
    [--equal(P2,Q2),
     ++equal(single_valued2(P2),single_valued2(Q2))]).

input_clause(single_valued3_substitution1,axiom,
    [--equal(R2,S2),
     ++equal(single_valued3(R2),single_valued3(S2))]).

input_clause(maps_substitution1,axiom,
    [--equal(X2,Y2),
     --maps(X2,Z2,A3),
     ++maps(Y2,Z2,A3)]).

input_clause(maps_substitution2,axiom,
    [--equal(B3,C3),
     --maps(D3,B3,E3),
     ++maps(D3,C3,E3)]).

input_clause(maps_substitution3,axiom,
    [--equal(F3,G3),
     --maps(H3,I3,F3),
     ++maps(H3,I3,G3)]).
%--------------------------------------------------------------------------
