%--------------------------------------------------------------------------
% File     : SET004=NBG1Subs-0 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Axioms   : Substitution axioms for set theory axioms
% Version  : [Quaife, 1992] axioms.
% English  : 

% Refs     : Quaife A. (1992), Automated Deduction in von 
%            Neumann-Bernays-Godel Set Theory, In Journal of Automated 
%            Reasoning 8(1), 91-147.
% Source   : [Quaife, 1992]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   65 (   0 non-Horn)(   0 units)
%            Number of literals          :  145 ( 115 equality)
%            Number of predicate symbols :   10 (   0 propositions)
%            Number of function symbols  :   30 (   0 constants)
%            Number of variables         :  196 (   0 singletons)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
input_clause(apply_substitution1,axiom,
    [--equal(D,E),
     ++equal(apply(D,F),apply(E,F))]).

input_clause(apply_substitution2,axiom,
    [--equal(G,H),
     ++equal(apply(I,G),apply(I,H))]).

input_clause(cantor_substitution1,axiom,
    [--equal(J,K),
     ++equal(cantor(J),cantor(K))]).

input_clause(complement_substitution1,axiom,
    [--equal(L,M),
     ++equal(complement(L),complement(M))]).

input_clause(compose_substitution1,axiom,
    [--equal(N,O),
     ++equal(compose(N,P),compose(O,P))]).

input_clause(compose_substitution2,axiom,
    [--equal(Q,R),
     ++equal(compose(S,Q),compose(S,R))]).

input_clause(cross_product_substitution1,axiom,
    [--equal(T,U),
     ++equal(cross_product(T,V),cross_product(U,V))]).

input_clause(cross_product_substitution2,axiom,
    [--equal(W,X),
     ++equal(cross_product(Y,W),cross_product(Y,X))]).

input_clause(diagonalise_substitution1,axiom,
    [--equal(Z,A1),
     ++equal(diagonalise(Z),diagonalise(A1))]).

input_clause(difference_substitution1,axiom,
    [--equal(B1,C1),
     ++equal(difference(B1,D1),difference(C1,D1))]).

input_clause(difference_substitution2,axiom,
    [--equal(E1,F1),
     ++equal(difference(G1,E1),difference(G1,F1))]).

input_clause(domain_substitution1,axiom,
    [--equal(H1,I1),
     ++equal(domain(H1,J1,K1),domain(I1,J1,K1))]).

input_clause(domain_substitution2,axiom,
    [--equal(L1,M1),
     ++equal(domain(N1,L1,O1),domain(N1,M1,O1))]).

input_clause(domain_substitution3,axiom,
    [--equal(P1,Q1),
     ++equal(domain(R1,S1,P1),domain(R1,S1,Q1))]).

input_clause(domain_of_substitution1,axiom,
    [--equal(T1,U1),
     ++equal(domain_of(T1),domain_of(U1))]).

input_clause(first_substitution1,axiom,
    [--equal(V1,W1),
     ++equal(first(V1),first(W1))]).

input_clause(flip_substitution1,axiom,
    [--equal(X1,Y1),
     ++equal(flip(X1),flip(Y1))]).

input_clause(image_substitution1,axiom,
    [--equal(Z1,A2),
     ++equal(image(Z1,B2),image(A2,B2))]).

input_clause(image_substitution2,axiom,
    [--equal(C2,D2),
     ++equal(image(E2,C2),image(E2,D2))]).

input_clause(intersection_substitution1,axiom,
    [--equal(F2,G2),
     ++equal(intersection(F2,H2),intersection(G2,H2))]).

input_clause(intersection_substitution2,axiom,
    [--equal(I2,J2),
     ++equal(intersection(K2,I2),intersection(K2,J2))]).

input_clause(inverse_substitution1,axiom,
    [--equal(L2,M2),
     ++equal(inverse(L2),inverse(M2))]).

input_clause(not_homomorphism1_substitution1,axiom,
    [--equal(N2,O2),
     ++equal(not_homomorphism1(N2,P2,Q2),not_homomorphism1(O2,P2,Q2))]).

input_clause(not_homomorphism1_substitution2,axiom,
    [--equal(R2,S2),
     ++equal(not_homomorphism1(T2,R2,U2),not_homomorphism1(T2,S2,U2))]).

input_clause(not_homomorphism1_substitution3,axiom,
    [--equal(V2,W2),
     ++equal(not_homomorphism1(X2,Y2,V2),not_homomorphism1(X2,Y2,W2))]).

input_clause(not_homomorphism2_substitution1,axiom,
    [--equal(Z2,A3),
     ++equal(not_homomorphism2(Z2,B3,C3),not_homomorphism2(A3,B3,C3))]).

input_clause(not_homomorphism2_substitution2,axiom,
    [--equal(D3,E3),
     ++equal(not_homomorphism2(F3,D3,G3),not_homomorphism2(F3,E3,G3))]).

input_clause(not_homomorphism2_substitution3,axiom,
    [--equal(H3,I3),
     ++equal(not_homomorphism2(J3,K3,H3),not_homomorphism2(J3,K3,I3))]).

input_clause(not_subclass_element_substitution1,axiom,
    [--equal(L3,M3),
     ++equal(not_subclass_element(L3,N3),not_subclass_element(M3,N3))]).

input_clause(not_subclass_element_substitution2,axiom,
    [--equal(O3,P3),
     ++equal(not_subclass_element(Q3,O3),not_subclass_element(Q3,P3))]).

input_clause(ordered_pair_substitution1,axiom,
    [--equal(R3,S3),
     ++equal(ordered_pair(R3,T3),ordered_pair(S3,T3))]).

input_clause(ordered_pair_substitution2,axiom,
    [--equal(U3,V3),
     ++equal(ordered_pair(W3,U3),ordered_pair(W3,V3))]).

input_clause(power_class_substitution1,axiom,
    [--equal(X3,Y3),
     ++equal(power_class(X3),power_class(Y3))]).

input_clause(range_substitution1,axiom,
    [--equal(Z3,A4),
     ++equal(range(Z3,B4,C4),range(A4,B4,C4))]).

input_clause(range_substitution2,axiom,
    [--equal(D4,E4),
     ++equal(range(F4,D4,G4),range(F4,E4,G4))]).

input_clause(range_substitution3,axiom,
    [--equal(H4,I4),
     ++equal(range(J4,K4,H4),range(J4,K4,I4))]).

input_clause(range_of_substitution1,axiom,
    [--equal(L4,M4),
     ++equal(range_of(L4),range_of(M4))]).

input_clause(regular_substitution1,axiom,
    [--equal(N4,O4),
     ++equal(regular(N4),regular(O4))]).

input_clause(restrict_substitution1,axiom,
    [--equal(P4,Q4),
     ++equal(restrict(P4,R4,S4),restrict(Q4,R4,S4))]).

input_clause(restrict_substitution2,axiom,
    [--equal(T4,U4),
     ++equal(restrict(V4,T4,W4),restrict(V4,U4,W4))]).

input_clause(restrict_substitution3,axiom,
    [--equal(X4,Y4),
     ++equal(restrict(Z4,A5,X4),restrict(Z4,A5,Y4))]).

input_clause(rotate_substitution1,axiom,
    [--equal(B5,C5),
     ++equal(rotate(B5),rotate(C5))]).

input_clause(second_substitution1,axiom,
    [--equal(D5,E5),
     ++equal(second(D5),second(E5))]).

input_clause(singleton_substitution1,axiom,
    [--equal(F5,G5),
     ++equal(singleton(F5),singleton(G5))]).

input_clause(successor_substitution1,axiom,
    [--equal(H5,I5),
     ++equal(successor(H5),successor(I5))]).

input_clause(sum_class_substitution1,axiom,
    [--equal(J5,K5),
     ++equal(sum_class(J5),sum_class(K5))]).

input_clause(union_substitution1,axiom,
    [--equal(L5,M5),
     ++equal(union(L5,N5),union(M5,N5))]).

input_clause(union_substitution2,axiom,
    [--equal(O5,P5),
     ++equal(union(Q5,O5),union(Q5,P5))]).

input_clause(unordered_pair_substitution1,axiom,
    [--equal(R5,S5),
     ++equal(unordered_pair(R5,T5),unordered_pair(S5,T5))]).

input_clause(unordered_pair_substitution2,axiom,
    [--equal(U5,V5),
     ++equal(unordered_pair(W5,U5),unordered_pair(W5,V5))]).

input_clause(compatible_substitution1,axiom,
    [--equal(X5,Y5),
     --compatible(X5,Z5,A6),
     ++compatible(Y5,Z5,A6)]).

input_clause(compatible_substitution2,axiom,
    [--equal(B6,C6),
     --compatible(D6,B6,E6),
     ++compatible(D6,C6,E6)]).

input_clause(compatible_substitution3,axiom,
    [--equal(F6,G6),
     --compatible(H6,I6,F6),
     ++compatible(H6,I6,G6)]).

input_clause(function_substitution1,axiom,
    [--equal(J6,K6),
     --function(J6),
     ++function(K6)]).

input_clause(homomorphism_substitution1,axiom,
    [--equal(L6,M6),
     --homomorphism(L6,N6,O6),
     ++homomorphism(M6,N6,O6)]).

input_clause(homomorphism_substitution2,axiom,
    [--equal(P6,Q6),
     --homomorphism(R6,P6,S6),
     ++homomorphism(R6,Q6,S6)]).

input_clause(homomorphism_substitution3,axiom,
    [--equal(T6,U6),
     --homomorphism(V6,W6,T6),
     ++homomorphism(V6,W6,U6)]).

input_clause(inductive_substitution1,axiom,
    [--equal(X6,Y6),
     --inductive(X6),
     ++inductive(Y6)]).

input_clause(member_substitution1,axiom,
    [--equal(Z6,A7),
     --member(Z6,B7),
     ++member(A7,B7)]).

input_clause(member_substitution2,axiom,
    [--equal(C7,D7),
     --member(E7,C7),
     ++member(E7,D7)]).

input_clause(one_to_one_substitution1,axiom,
    [--equal(F7,G7),
     --one_to_one(F7),
     ++one_to_one(G7)]).

input_clause(operation_substitution1,axiom,
    [--equal(H7,I7),
     --operation(H7),
     ++operation(I7)]).

input_clause(single_valued_class_substitution1,axiom,
    [--equal(J7,K7),
     --single_valued_class(J7),
     ++single_valued_class(K7)]).

input_clause(subclass_substitution1,axiom,
    [--equal(L7,M7),
     --subclass(L7,N7),
     ++subclass(M7,N7)]).

input_clause(subclass_substitution2,axiom,
    [--equal(O7,P7),
     --subclass(Q7,O7),
     ++subclass(Q7,P7)]).
%--------------------------------------------------------------------------
