%--------------------------------------------------------------------------
% File     : SET003=GodelSet1Subs-0 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Axioms   : Substitution axioms for set theory axioms
% Version  : [Boyer, et al., 1986] axioms.
% English  : 

% Refs     : Boyer R., Lusk E., McCune W., Overbeek R., Stickel M. and 
%            Wos L. (1986), Set Theory in First-Order Logic: Clauses for 
%            Godel's Axioms,  Journal of Automated Reasoning 2(3), 
%            287-327.
%          : Wos L. (1988), Automated Reasoning: 33 Basic Research 
%            Problems, Prentice-Hall.
% Source   : [TPTP]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :  122 (   0 non-Horn)(   0 units)
%            Number of literals          :  268 ( 220 equality)
%            Number of predicate symbols :   14 (   0 propositions)
%            Number of function symbols  :   53 (   0 constants)
%            Number of variables         :  406 (   0 singletons)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : These should be in the Boyer paper, but they use 
%            paramodulation, and hence omit them.
%          : These axioms are based on Godel's axioms for set theory.
%          : These axioms are also used in [Wos, 1988, p. 225].
%--------------------------------------------------------------------------
input_clause(f1_substitution1,axiom,
    [--equal(A,B),
     ++equal(f1(A,C),f1(B,C))]).

input_clause(f1_substitution2,axiom,
    [--equal(D,E),
     ++equal(f1(F,D),f1(F,E))]).

input_clause(f2_substitution1,axiom,
    [--equal(A2,B2),
     ++equal(f2(A2),f2(B2))]).

input_clause(f3_substitution1,axiom,
    [--equal(G4,H4),
     ++equal(f3(G4),f3(H4))]).

input_clause(f4_substitution1,axiom,
    [--equal(O7,P7),
     ++equal(f4(O7,Q7),f4(P7,Q7))]).

input_clause(f4_substitution2,axiom,
    [--equal(R7,S7),
     ++equal(f4(T7,R7),f4(T7,S7))]).

input_clause(f5_substitution1,axiom,
    [--equal(U7,V7),
     ++equal(f5(U7,W7),f5(V7,W7))]).

input_clause(f5_substitution2,axiom,
    [--equal(X7,Y7),
     ++equal(f5(Z7,X7),f5(Z7,Y7))]).

input_clause(f6_substitution1,axiom,
    [--equal(A8,B8),
     ++equal(f6(A8,C8),f6(B8,C8))]).

input_clause(f6_substitution2,axiom,
    [--equal(D8,E8),
     ++equal(f6(F8,D8),f6(F8,E8))]).

input_clause(f7_substitution1,axiom,
    [--equal(G8,H8),
     ++equal(f7(G8,I8),f7(H8,I8))]).

input_clause(f7_substitution2,axiom,
    [--equal(J8,K8),
     ++equal(f7(L8,J8),f7(L8,K8))]).

input_clause(f8_substitution1,axiom,
    [--equal(M8,N8),
     ++equal(f8(M8,O8),f8(N8,O8))]).

input_clause(f8_substitution2,axiom,
    [--equal(P8,Q8),
     ++equal(f8(R8,P8),f8(R8,Q8))]).

input_clause(f9_substitution1,axiom,
    [--equal(S8,T8),
     ++equal(f9(S8,U8),f9(T8,U8))]).

input_clause(f9_substitution2,axiom,
    [--equal(V8,W8),
     ++equal(f9(X8,V8),f9(X8,W8))]).

input_clause(f10_substitution1,axiom,
    [--equal(G,H),
     ++equal(f10(G,I),f10(H,I))]).

input_clause(f10_substitution2,axiom,
    [--equal(J,K),
     ++equal(f10(L,J),f10(L,K))]).

input_clause(f11_substitution1,axiom,
    [--equal(M,N),
     ++equal(f11(M,O),f11(N,O))]).

input_clause(f11_substitution2,axiom,
    [--equal(P,Q),
     ++equal(f11(R,P),f11(R,Q))]).

input_clause(f12_substitution1,axiom,
    [--equal(S,T),
     ++equal(f12(S,U),f12(T,U))]).

input_clause(f12_substitution2,axiom,
    [--equal(V,W),
     ++equal(f12(X,V),f12(X,W))]).

input_clause(f13_substitution1,axiom,
    [--equal(Y,Z),
     ++equal(f13(Y,A1),f13(Z,A1))]).

input_clause(f13_substitution2,axiom,
    [--equal(B1,C1),
     ++equal(f13(D1,B1),f13(D1,C1))]).

input_clause(f14_substitution1,axiom,
    [--equal(E1,F1),
     ++equal(f14(E1,G1),f14(F1,G1))]).

input_clause(f14_substitution2,axiom,
    [--equal(H1,I1),
     ++equal(f14(J1,H1),f14(J1,I1))]).

input_clause(f16_substitution1,axiom,
    [--equal(K1,L1),
     ++equal(f16(K1,M1),f16(L1,M1))]).

input_clause(f16_substitution2,axiom,
    [--equal(N1,O1),
     ++equal(f16(P1,N1),f16(P1,O1))]).

input_clause(f17_substitution1,axiom,
    [--equal(Q1,R1),
     ++equal(f17(Q1,S1),f17(R1,S1))]).

input_clause(f17_substitution2,axiom,
    [--equal(T1,U1),
     ++equal(f17(V1,T1),f17(V1,U1))]).

input_clause(f18_substitution1,axiom,
    [--equal(W1,X1),
     ++equal(f18(W1),f18(X1))]).

input_clause(f19_substitution1,axiom,
    [--equal(Y1,Z1),
     ++equal(f19(Y1),f19(Z1))]).

input_clause(f20_substitution1,axiom,
    [--equal(C2,D2),
     ++equal(f20(C2),f20(D2))]).

input_clause(f21_substitution1,axiom,
    [--equal(E2,F2),
     ++equal(f21(E2),f21(F2))]).

input_clause(f22_substitution1,axiom,
    [--equal(G2,H2),
     ++equal(f22(G2,I2,J2),f22(H2,I2,J2))]).

input_clause(f22_substitution2,axiom,
    [--equal(K2,L2),
     ++equal(f22(M2,K2,N2),f22(M2,L2,N2))]).

input_clause(f22_substitution3,axiom,
    [--equal(O2,P2),
     ++equal(f22(Q2,R2,O2),f22(Q2,R2,P2))]).

input_clause(f23_substitution1,axiom,
    [--equal(S2,T2),
     ++equal(f23(S2,U2),f23(T2,U2))]).

input_clause(f23_substitution2,axiom,
    [--equal(V2,W2),
     ++equal(f23(X2,V2),f23(X2,W2))]).

input_clause(f24_substitution1,axiom,
    [--equal(Y2,Z2),
     ++equal(f24(Y2),f24(Z2))]).

input_clause(f26_substitution1,axiom,
    [--equal(A3,B3),
     ++equal(f26(A3),f26(B3))]).

input_clause(f27_substitution1,axiom,
    [--equal(C3,D3),
     ++equal(f27(C3,E3),f27(D3,E3))]).

input_clause(f27_substitution2,axiom,
    [--equal(F3,G3),
     ++equal(f27(H3,F3),f27(H3,G3))]).

input_clause(f28_substitution1,axiom,
    [--equal(I3,J3),
     ++equal(f28(I3,K3,L3),f28(J3,K3,L3))]).

input_clause(f28_substitution2,axiom,
    [--equal(M3,N3),
     ++equal(f28(O3,M3,P3),f28(O3,N3,P3))]).

input_clause(f28_substitution3,axiom,
    [--equal(Q3,R3),
     ++equal(f28(S3,T3,Q3),f28(S3,T3,R3))]).

input_clause(f29_substitution1,axiom,
    [--equal(U3,V3),
     ++equal(f29(U3,W3,X3),f29(V3,W3,X3))]).

input_clause(f29_substitution2,axiom,
    [--equal(Y3,Z3),
     ++equal(f29(A4,Y3,B4),f29(A4,Z3,B4))]).

input_clause(f29_substitution3,axiom,
    [--equal(C4,D4),
     ++equal(f29(E4,F4,C4),f29(E4,F4,D4))]).

input_clause(f30_substitution1,axiom,
    [--equal(I4,J4),
     ++equal(f30(I4,K4,L4),f30(J4,K4,L4))]).

input_clause(f30_substitution2,axiom,
    [--equal(M4,N4),
     ++equal(f30(O4,M4,P4),f30(O4,N4,P4))]).

input_clause(f30_substitution3,axiom,
    [--equal(Q4,R4),
     ++equal(f30(S4,T4,Q4),f30(S4,T4,R4))]).

input_clause(f31_substitution1,axiom,
    [--equal(U4,V4),
     ++equal(f31(U4,W4,X4),f31(V4,W4,X4))]).

input_clause(f31_substitution2,axiom,
    [--equal(Y4,Z4),
     ++equal(f31(A5,Y4,B5),f31(A5,Z4,B5))]).

input_clause(f31_substitution3,axiom,
    [--equal(C5,D5),
     ++equal(f31(E5,F5,C5),f31(E5,F5,D5))]).

input_clause(f32_substitution1,axiom,
    [--equal(G5,H5),
     ++equal(f32(G5,I5,J5,K5,L5),f32(H5,I5,J5,K5,L5))]).

input_clause(f32_substitution2,axiom,
    [--equal(M5,N5),
     ++equal(f32(O5,M5,P5,Q5,R5),f32(O5,N5,P5,Q5,R5))]).

input_clause(f32_substitution3,axiom,
    [--equal(S5,T5),
     ++equal(f32(U5,V5,S5,W5,X5),f32(U5,V5,T5,W5,X5))]).

input_clause(f32_substitution4,axiom,
    [--equal(Y5,Z5),
     ++equal(f32(A6,B6,C6,Y5,D6),f32(A6,B6,C6,Z5,D6))]).

input_clause(f32_substitution5,axiom,
    [--equal(E6,F6),
     ++equal(f32(G6,H6,I6,J6,E6),f32(G6,H6,I6,J6,F6))]).

input_clause(f33_substitution1,axiom,
    [--equal(K6,L6),
     ++equal(f33(K6,M6,N6,O6,P6),f33(L6,M6,N6,O6,P6))]).

input_clause(f33_substitution2,axiom,
    [--equal(Q6,R6),
     ++equal(f33(S6,Q6,T6,U6,V6),f33(S6,R6,T6,U6,V6))]).

input_clause(f33_substitution3,axiom,
    [--equal(W6,X6),
     ++equal(f33(Y6,Z6,W6,A7,B7),f33(Y6,Z6,X6,A7,B7))]).

input_clause(f33_substitution4,axiom,
    [--equal(C7,D7),
     ++equal(f33(E7,F7,G7,C7,H7),f33(E7,F7,G7,D7,H7))]).

input_clause(f33_substitution5,axiom,
    [--equal(I7,J7),
     ++equal(f33(K7,L7,M7,N7,I7),f33(K7,L7,M7,N7,J7))]).

input_clause(apply_substitution1,axiom,
    [--equal(A,B),
     ++equal(apply(A,C),apply(B,C))]).

input_clause(apply_substitution2,axiom,
    [--equal(D,E),
     ++equal(apply(F,D),apply(F,E))]).

input_clause(apply_to_two_arguments_substitution1,axiom,
    [--equal(G,H),
     ++equal(apply_to_two_arguments(G,I,J),apply_to_two_arguments(H,I,J))]).

input_clause(apply_to_two_arguments_substitution2,axiom,
    [--equal(K,L),
     ++equal(apply_to_two_arguments(M,K,N),apply_to_two_arguments(M,L,N))]).

input_clause(apply_to_two_arguments_substitution3,axiom,
    [--equal(O,P),
     ++equal(apply_to_two_arguments(Q,R,O),apply_to_two_arguments(Q,R,P))]).

input_clause(complement_substitution1,axiom,
    [--equal(S,T),
     ++equal(complement(S),complement(T))]).

input_clause(composition_substitution1,axiom,
    [--equal(U,V),
     ++equal(composition(U,W),composition(V,W))]).

input_clause(composition_substitution2,axiom,
    [--equal(X,Y),
     ++equal(composition(Z,X),composition(Z,Y))]).

input_clause(converse_substitution1,axiom,
    [--equal(A1,B1),
     ++equal(converse(A1),converse(B1))]).

input_clause(cross_product_substitution1,axiom,
    [--equal(C1,D1),
     ++equal(cross_product(C1,E1),cross_product(D1,E1))]).

input_clause(cross_product_substitution2,axiom,
    [--equal(F1,G1),
     ++equal(cross_product(H1,F1),cross_product(H1,G1))]).

input_clause(domain_substitution1,axiom,
    [--equal(I1,J1),
     ++equal(domain_of(I1),domain_of(J1))]).

input_clause(first_substitution1,axiom,
    [--equal(I10,J10),
     ++equal(first(I10),first(J10))]).

input_clause(flip_range_substitution1,axiom,
    [--equal(Q10,R10),
     ++equal(flip_range_of(Q10),flip_range_of(R10))]).

input_clause(image_substitution1,axiom,
    [--equal(S10,T10),
     ++equal(image(S10,U10),image(T10,U10))]).

input_clause(image_substitution2,axiom,
    [--equal(V10,W10),
     ++equal(image(X10,V10),image(X10,W10))]).

input_clause(intersection_substitution1,axiom,
    [--equal(Y10,Z10),
     ++equal(intersection(Y10,A11),intersection(Z10,A11))]).

input_clause(intersection_substitution2,axiom,
    [--equal(B11,C11),
     ++equal(intersection(D11,B11),intersection(D11,C11))]).

input_clause(non_ordered_pair_substitution1,axiom,
    [--equal(E11,F11),
     ++equal(non_ordered_pair(E11,G11),non_ordered_pair(F11,G11))]).

input_clause(non_ordered_pair_substitution2,axiom,
    [--equal(H11,I11),
     ++equal(non_ordered_pair(J11,H11),non_ordered_pair(J11,I11))]).

input_clause(ordered_pair_substitution1,axiom,
    [--equal(K11,L11),
     ++equal(ordered_pair(K11,M11),ordered_pair(L11,M11))]).

input_clause(ordered_pair_substitution2,axiom,
    [--equal(N11,O11),
     ++equal(ordered_pair(P11,N11),ordered_pair(P11,O11))]).

input_clause(powerset_substitution1,axiom,
    [--equal(Q11,R11),
     ++equal(powerset(Q11),powerset(R11))]).

input_clause(range_substitution1,axiom,
    [--equal(S11,T11),
     ++equal(range_of(S11),range_of(T11))]).

input_clause(restrict_substitution1,axiom,
    [--equal(U11,V11),
     ++equal(restrict(U11,W11),restrict(V11,W11))]).

input_clause(restrict_substitution2,axiom,
    [--equal(X11,Y11),
     ++equal(restrict(Z11,X11),restrict(Z11,Y11))]).

input_clause(rotate_right_substitution1,axiom,
    [--equal(A12,B12),
     ++equal(rotate_right(A12),rotate_right(B12))]).

input_clause(second_substitution1,axiom,
    [--equal(C12,D12),
     ++equal(second(C12),second(D12))]).

input_clause(sigma_substitution1,axiom,
    [--equal(K12,L12),
     ++equal(sigma(K12),sigma(L12))]).

input_clause(singleton_set_substitution1,axiom,
    [--equal(M12,N12),
     ++equal(singleton_set(M12),singleton_set(N12))]).

input_clause(successor_substitution1,axiom,
    [--equal(O12,P12),
     ++equal(successor(O12),successor(P12))]).

input_clause(union_substitution1,axiom,
    [--equal(Q12,R12),
     ++equal(union(Q12,S12),union(R12,S12))]).

input_clause(union_substitution2,axiom,
    [--equal(T12,U12),
     ++equal(union(V12,T12),union(V12,U12))]).

input_clause(closed_substitution1,axiom,
    [--equal(W12,X12),
     --closed(W12,Y12),
     ++closed(X12,Y12)]).

input_clause(closed_substitution2,axiom,
    [--equal(Z12,A13),
     --closed(B13,Z12),
     ++closed(B13,A13)]).

input_clause(disjoint_substitution1,axiom,
    [--equal(C13,D13),
     --disjoint(C13,E13),
     ++disjoint(D13,E13)]).

input_clause(disjoint_substitution2,axiom,
    [--equal(F13,G13),
     --disjoint(H13,F13),
     ++disjoint(H13,G13)]).

input_clause(function_substitution1,axiom,
    [--equal(I13,J13),
     --function(I13),
     ++function(J13)]).

input_clause(homomorphism_substitution1,axiom,
    [--equal(K13,L13),
     --homomorphism(K13,M13,N13,O13,P13),
     ++homomorphism(L13,M13,N13,O13,P13)]).

input_clause(homomorphism_substitution2,axiom,
    [--equal(Q13,R13),
     --homomorphism(S13,Q13,T13,U13,V13),
     ++homomorphism(S13,R13,T13,U13,V13)]).

input_clause(homomorphism_substitution3,axiom,
    [--equal(W13,X13),
     --homomorphism(Y13,Z13,W13,A14,B14),
     ++homomorphism(Y13,Z13,X13,A14,B14)]).

input_clause(homomorphism_substitution4,axiom,
    [--equal(C14,D14),
     --homomorphism(E14,F14,G14,C14,H14),
     ++homomorphism(E14,F14,G14,D14,H14)]).

input_clause(homomorphism_substitution5,axiom,
    [--equal(I14,J14),
     --homomorphism(K14,L14,M14,N14,I14),
     ++homomorphism(K14,L14,M14,N14,J14)]).

input_clause(little_set_substitution1,axiom,
    [--equal(O14,P14),
     --little_set(O14),
     ++little_set(P14)]).

input_clause(maps_substitution1,axiom,
    [--equal(Q14,R14),
     --maps(Q14,S14,T14),
     ++maps(R14,S14,T14)]).

input_clause(maps_substitution2,axiom,
    [--equal(U14,V14),
     --maps(W14,U14,X14),
     ++maps(W14,V14,X14)]).

input_clause(maps_substitution3,axiom,
    [--equal(Y14,Z14),
     --maps(A15,B15,Y14),
     ++maps(A15,B15,Z14)]).

input_clause(member_substitution1,axiom,
    [--equal(C15,D15),
     --member(C15,E15),
     ++member(D15,E15)]).

input_clause(member_substitution2,axiom,
    [--equal(F15,G15),
     --member(H15,F15),
     ++member(H15,G15)]).

input_clause(one_to_one_function_substitution1,axiom,
    [--equal(I15,J15),
     --one_to_one_function(I15),
     ++one_to_one_function(J15)]).

input_clause(ordered_pair_predicate_substitution1,axiom,
    [--equal(K15,L15),
     --ordered_pair_predicate(K15),
     ++ordered_pair_predicate(L15)]).

input_clause(proper_subset_substitution1,axiom,
    [--equal(M15,N15),
     --proper_subset(M15,O15),
     ++proper_subset(N15,O15)]).

input_clause(proper_subset_substitution2,axiom,
    [--equal(P15,Q15),
     --proper_subset(R15,P15),
     ++proper_subset(R15,Q15)]).

input_clause(relation_substitution1,axiom,
    [--equal(S15,T15),
     --relation(S15),
     ++relation(T15)]).

input_clause(single_valued_set_substitution1,axiom,
    [--equal(U15,V15),
     --single_valued_set(U15),
     ++single_valued_set(V15)]).

input_clause(subset_substitution1,axiom,
    [--equal(W15,X15),
     --subset(W15,Y15),
     ++subset(X15,Y15)]).

input_clause(subset_substitution2,axiom,
    [--equal(Z15,A16),
     --subset(B16,Z15),
     ++subset(B16,A16)]).
%--------------------------------------------------------------------------
