%--------------------------------------------------------------------------
% File     : SET002=Naive2Subs-0 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Axioms   : Substitution axioms for set theory axioms
% Version  : [McCharen, et al., 1976] axioms.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   11 (   0 non-Horn)(   0 units)
%            Number of literals          :   26 (   0 equality)
%            Number of predicate symbols :    4 (   0 propositions)
%            Number of function symbols  :    4 (   0 constants)
%            Number of variables         :   32 (   0 singletons)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%-----Equality substitution axioms.
input_clause(member_substitution1,axiom,
    [--equal_elements(X,Y),
     --member(X,Xs),
     ++member(Y,Xs)]).

input_clause(member_substitution2,axiom,
    [--equal_sets(Xs,Ys),
     --member(X,Xs),
     ++member(X,Ys)]).

input_clause(subset_substitution1,axiom,
    [--equal_sets(Xs,Xp),
     --subset(Xs,Ys),
     ++subset(Xp,Ys)]).

input_clause(subset_substitution2,axiom,
    [--equal_sets(Ys,Yp),
     --subset(Xs,Ys),
     ++subset(Xs,Yp)]).

input_clause(member_of_1_not_of_2_substitution1,axiom,
    [--equal_sets(Xs,Xp),
     ++equal_elements(member_of_1_not_of_2(Xs,Ys),
member_of_1_not_of_2(Xp,Ys))]).

input_clause(member_of_1_not_of_2_substitution2,axiom,
    [--equal_sets(Ys,Yp),
     ++equal_elements(member_of_1_not_of_2(Xs,Ys),
member_of_1_not_of_2(Xs,Yp))]).

input_clause(complement_substitution,axiom,
    [--equal_sets(Xs,Xp),
     ++equal_sets(complement(Xs),complement(Xp))]).

input_clause(union_substitution1,axiom,
    [--equal_sets(Xs,Xp),
     ++equal_elements(union(Xs,Ys),union(Xp,Ys))]).

input_clause(union_substitution2,axiom,
    [--equal_sets(Ys,Yp),
     ++equal_elements(union(Xs,Ys),union(Xs,Yp))]).

input_clause(intersection_substitution1,axiom,
    [--equal_sets(Xs,Xp),
     ++equal_elements(intersection(Xs,Ys),intersection(Xp,Ys))]).

input_clause(intersection_substitution2,axiom,
    [--equal_sets(Ys,Yp),
     ++equal_elements(intersection(Xs,Ys),intersection(Xs,Yp))]).
%--------------------------------------------------------------------------
