%--------------------------------------------------------------------------
% File     : RNG001=Rings1Subs-0 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Ring Theory
% Axioms   : Substitution axioms for ring theory axioms
% Version  : [McCharen, et al., 1976] axioms.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Wos L. (1988), Automated Reasoning: 33 Basic Research 
%            Problems, Prentice-Hall.
% Source   : [McCharen, et al., 1976]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   13 (   0 non-Horn)(   0 units)
%            Number of literals          :   34 (  18 equality)
%            Number of predicate symbols :    3 (   0 propositions)
%            Number of function symbols  :    3 (   0 constants)
%            Number of variables         :   46 (   0 singletons)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : These axioms are used in [Wos, 1988, p. 201]
%--------------------------------------------------------------------------
input_clause(additive_inverse_substitution,axiom,
    [--equal(X,Y),
     ++equal(additive_inverse(X),additive_inverse(Y))]).

input_clause(add_substitution1,axiom,
    [--equal(X,Y),
     ++equal(add(X,W),add(Y,W))]).

input_clause(add_substitution2,axiom,
    [--equal(X,Y),
     ++equal(add(W,X),add(W,Y))]).

input_clause(sum_substitution1,axiom,
    [--equal(X,Y),
     --sum(X,W,Z),
     ++sum(Y,W,Z)]).

input_clause(sum_substitution2,axiom,
    [--equal(X,Y),
     --sum(W,X,Z),
     ++sum(W,Y,Z)]).

input_clause(sum_substitution3,axiom,
    [--equal(X,Y),
     --sum(W,Z,X),
     ++sum(W,Z,Y)]).

input_clause(multiply_substitution1,axiom,
    [--equal(X,Y),
     ++equal(multiply(X,W),multiply(Y,W))]).

input_clause(multiply_substitution2,axiom,
    [--equal(X,Y),
     ++equal(multiply(W,X),multiply(W,Y))]).

input_clause(product_substitution1,axiom,
    [--equal(X,Y),
     --product(X,W,Z),
     ++product(Y,W,Z)]).

input_clause(product_substitution2,axiom,
    [--equal(X,Y),
     --product(W,X,Z),
     ++product(W,Y,Z)]).

input_clause(product_substitution3,axiom,
    [--equal(X,Y),
     --product(W,Z,X),
     ++product(W,Z,Y)]).
%--------------------------------------------------------------------------
