%--------------------------------------------------------------------------
% File     : PRV002=ProgVer2Subs-0 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Program Verification
% Axioms   : Substitution axioms for program verification axioms
% Version  : [McCharen, et al., 1976] axioms.
% English  : These "clauses arose in a natural manner from work done 
%            in program verification" [McCharen, et al., 1976, p. 779].

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [McCharen, et al., 1976]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :    4 (   0 non-Horn)(   0 units)
%            Number of literals          :   10 (   4 equality)
%            Number of predicate symbols :    2 (   0 propositions)
%            Number of function symbols  :    1 (   0 constants)
%            Number of variables         :   10 (   0 singletons)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : This axiom was contributed to [McCharen, et al., 1976] 
%            by E. McCharen.
%--------------------------------------------------------------------------
input_clause(less_or_equal_substitution1,axiom,
    [--equal(X,Y),
     --less_or_equal(X,Z),
     ++less_or_equal(Y,Z)]).

input_clause(less_or_equal_substitution2,axiom,
    [--equal(X,Y),
     --less_or_equal(Z,X),
     ++less_or_equal(Z,Y)]).

input_clause(successor_substitution,axiom,
    [--equal(X,Y),
     ++equal(successor(X),successor(Y))]).

input_clause(successor_less_or_equal_substitution,axiom,
    [--less_or_equal(X,Y),
     ++less_or_equal(successor(X),successor(Y))]).
%--------------------------------------------------------------------------
