%--------------------------------------------------------------------------
% File     : PRV001=ProgVer1Subs-0 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Program Verification
% Axioms   : Substitution axioms for program verification axioms
% Version  : [McCharen, et al., 1976] axioms.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [McCharen, et al., 1976]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :    3 (   0 non-Horn)(   0 units)
%            Number of literals          :    6 (   6 equality)
%            Number of predicate symbols :    1 (   0 propositions)
%            Number of function symbols  :    3 (   0 constants)
%            Number of variables         :    6 (   0 singletons)
%            Maximal clause size         :    2
%            Maximal term depth          :    2

% Comments : Only reflexivity is specified from equality, i.e. no symmetry 
%            or transitivity.
%          : This axiom was contributed to [McCharen, et al., 1976] 
%            in private correspondance from G. Ernst.
%--------------------------------------------------------------------------
input_clause(predecessor_substitution,axiom,
    [++equal(predecessor(X),predecessor(Y)),
     --equal(X,Y)]).

input_clause(successor_substitution,axiom,
    [++equal(successor(X),successor(Y)),
     --equal(X,Y)]).

input_clause(a_substitution,axiom,
    [++equal(a(X),a(Y)),
     --equal(X,Y)]).
%--------------------------------------------------------------------------
