%--------------------------------------------------------------------------
% File     : NUM004=OrdinalsSubs-0 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Number Theory (Ordinals)
% Axioms   : Substitution axioms for number theory axioms
% Version  : [Quaife, 1992] axioms.
% English  : 

% Refs     : Quaife A. (1992), Email to Geoff Sutcliffe.
% Source   : [TPTP]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   31 (   0 non-Horn)(   0 units)
%            Number of literals          :   75 (  49 equality)
%            Number of predicate symbols :    7 (   0 propositions)
%            Number of function symbols  :   10 (   0 constants)
%            Number of variables         :   98 (   0 singletons)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
input_clause(integer_of_substitution1,axiom,
    [--equal(D,E),
     ++equal(integer_of(D),integer_of(E))]).

input_clause(least_substitution1,axiom,
    [--equal(F,G),
     ++equal(least(F,H),least(G,H))]).

input_clause(least_substitution2,axiom,
    [--equal(I,J),
     ++equal(least(K,I),least(K,J))]).

input_clause(not_well_ordering_substitution1,axiom,
    [--equal(L,M),
     ++equal(not_well_ordering(L,N),not_well_ordering(M,N))]).

input_clause(not_well_ordering_substitution2,axiom,
    [--equal(O,P),
     ++equal(not_well_ordering(Q,O),not_well_ordering(Q,P))]).

input_clause(ordinal_add_substitution1,axiom,
    [--equal(R,S),
     ++equal(ordinal_add(R,T),ordinal_add(S,T))]).

input_clause(ordinal_add_substitution2,axiom,
    [--equal(U,V),
     ++equal(ordinal_add(W,U),ordinal_add(W,V))]).

input_clause(ordinal_multiply_substitution1,axiom,
    [--equal(X,Y),
     ++equal(ordinal_multiply(X,Z),ordinal_multiply(Y,Z))]).

input_clause(ordinal_multiply_substitution2,axiom,
    [--equal(A1,B1),
     ++equal(ordinal_multiply(C1,A1),ordinal_multiply(C1,B1))]).

input_clause(recursion_substitution1,axiom,
    [--equal(F1,G1),
     ++equal(recursion(F1,H1,I1),recursion(G1,H1,I1))]).

input_clause(recursion_substitution2,axiom,
    [--equal(J1,K1),
     ++equal(recursion(L1,J1,M1),recursion(L1,K1,M1))]).

input_clause(recursion_substitution3,axiom,
    [--equal(N1,O1),
     ++equal(recursion(P1,Q1,N1),recursion(P1,Q1,O1))]).

input_clause(recursion_equation_functions_substitution1,axiom,
    [--equal(R1,S1),
     ++equal(recursion_equation_functions(R1),recursion_equation_functions(S1))]).

input_clause(rest_of_substitution1,axiom,
    [--equal(T1,U1),
     ++equal(rest_of(T1),rest_of(U1))]).

input_clause(segment_substitution1,axiom,
    [--equal(V1,W1),
     ++equal(segment(V1,X1,Y1),segment(W1,X1,Y1))]).

input_clause(segment_substitution2,axiom,
    [--equal(Z1,A2),
     ++equal(segment(B2,Z1,C2),segment(B2,A2,C2))]).

input_clause(segment_substitution3,axiom,
    [--equal(D2,E2),
     ++equal(segment(F2,G2,D2),segment(F2,G2,E2))]).

input_clause(symmetrization_of_substitution1,axiom,
    [--equal(H2,I2),
     ++equal(symmetrization_of(H2),symmetrization_of(I2))]).

input_clause(asymmetric_substitution1,axiom,
    [--equal(J2,K2),
     --asymmetric(J2,L2),
     ++asymmetric(K2,L2)]).

input_clause(asymmetric_substitution2,axiom,
    [--equal(M2,N2),
     --asymmetric(O2,M2),
     ++asymmetric(O2,N2)]).

input_clause(connected_substitution1,axiom,
    [--equal(P2,Q2),
     --connected(P2,R2),
     ++connected(Q2,R2)]).

input_clause(connected_substitution2,axiom,
    [--equal(S2,T2),
     --connected(U2,S2),
     ++connected(U2,T2)]).

input_clause(irreflexive_substitution1,axiom,
    [--equal(V2,W2),
     --irreflexive(V2,X2),
     ++irreflexive(W2,X2)]).

input_clause(irreflexive_substitution2,axiom,
    [--equal(Y2,Z2),
     --irreflexive(A3,Y2),
     ++irreflexive(A3,Z2)]).

input_clause(section_substitution1,axiom,
    [--equal(B3,C3),
     --section(B3,D3,E3),
     ++section(C3,D3,E3)]).

input_clause(section_substitution2,axiom,
    [--equal(F3,G3),
     --section(H3,F3,I3),
     ++section(H3,G3,I3)]).

input_clause(section_substitution3,axiom,
    [--equal(J3,K3),
     --section(L3,M3,J3),
     ++section(L3,M3,K3)]).

input_clause(transitive_substitution1,axiom,
    [--equal(N3,O3),
     --transitive(N3,P3),
     ++transitive(O3,P3)]).

input_clause(transitive_substitution2,axiom,
    [--equal(Q3,R3),
     --transitive(S3,Q3),
     ++transitive(S3,R3)]).

input_clause(well_ordering_substitution1,axiom,
    [--equal(T3,U3),
     --well_ordering(T3,V3),
     ++well_ordering(U3,V3)]).

input_clause(well_ordering_substitution2,axiom,
    [--equal(W3,X3),
     --well_ordering(Y3,W3),
     ++well_ordering(Y3,X3)]).
%--------------------------------------------------------------------------
